"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerTotalStats = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawler_logic = require("./crawler/crawler_logic");
var _name_and_description_stats = require("./name_and_description_stats");
var _overview = require("./overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerTotalStats = () => {
  var _indexData$count;
  const {
    domains,
    dataLoading
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  const {
    indexData,
    isError,
    isLoading
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const documentCount = (_indexData$count = indexData === null || indexData === void 0 ? void 0 : indexData.count) !== null && _indexData$count !== void 0 ? _indexData$count : 0;
  const hideStats = isLoading || isError;
  const stats = [{
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.ingestionTypeCardLabel', {
      defaultMessage: 'Ingestion type'
    }),
    isLoading: hideStats,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.crawlerIngestionMethodLabel', {
      defaultMessage: 'Crawler'
    })
  }, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.domainCountCardLabel', {
      defaultMessage: 'Domain count'
    }),
    isLoading: dataLoading || hideStats,
    title: domains.length
  }, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.documentCountCardLabel', {
      defaultMessage: 'Document count'
    }),
    isLoading: hideStats,
    title: documentCount
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_name_and_description_stats.NameAndDescriptionStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, stats.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: index === 0 ? 'primary' : 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, (0, _extends2.default)({
    titleSize: "m"
  }, item)))))));
};
exports.CrawlerTotalStats = CrawlerTotalStats;