"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeleteDomainConfirmationMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeleteDomainConfirmationMessage = domainUrl => {
  return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.action.deleteDomain.confirmationPopupMessage', {
    defaultMessage: 'Are you sure you want to remove the domain "{domainUrl}" and all of its settings?',
    values: {
      domainUrl
    }
  });
};
exports.getDeleteDomainConfirmationMessage = getDeleteDomainConfirmationMessage;