"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDomainForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _add_domain_logic = require("./add_domain_logic");
var _add_domain_validation = require("./add_domain_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDomainForm = () => {
  const {
    setAddDomainFormInputValue,
    startDomainValidation
  } = (0, _kea.useActions)(_add_domain_logic.AddDomainLogic);
  const {
    addDomainFormInputValue,
    displayValidation,
    entryPointValue
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      startDomainValidation();
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.urlLabel', {
      defaultMessage: 'Domain URL'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.urlHelpText', {
      defaultMessage: 'Domain URLs require a protocol and cannot contain any paths.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    clear: {
      onClick: () => setAddDomainFormInputValue('')
    },
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    value: addDomainFormInputValue,
    onChange: e => setAddDomainFormInputValue(e.target.value),
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    fill: true,
    disabled: addDomainFormInputValue.length === 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.validateButtonLabel', {
    defaultMessage: 'Validate Domain'
  }))))), entryPointValue !== '/' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.crawler.addDomainForm.entryPointLabel",
    defaultMessage: "Web Crawler entry point has been set as {entryPointValue}",
    values: {
      entryPointValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, entryPointValue)
    }
  }))))), displayValidation && /*#__PURE__*/_react.default.createElement(_add_domain_validation.AddDomainValidation, null)));
};
exports.AddDomainForm = AddDomainForm;