"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtractionRulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../shared/constants");
var _content_fields_panel = require("./content_fields_panel");
var _extraction_rules_logic = require("./extraction_rules_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExtractionRulesTable = () => {
  const {
    deleteFieldRule,
    editExtractionRule,
    hideDeleteFieldModal,
    openEditRuleFlyout,
    showDeleteFieldModal,
    showDeleteModal
  } = (0, _kea.useActions)(_extraction_rules_logic.ExtractionRulesLogic);
  const {
    deleteFieldModalVisible,
    extractionRules
  } = (0, _kea.useValues)(_extraction_rules_logic.ExtractionRulesLogic);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    setItemIdToExpandedRowMap({});
  }, [extractionRules]);
  const toggleExpandedItem = item => {
    if (itemIdToExpandedRowMap[item.id]) {
      // omit item from rowmap
      const {
        [item.id]: _,
        ...rest
      } = itemIdToExpandedRowMap;
      setItemIdToExpandedRowMap(rest);
    } else {
      const rules = item.rules.map((val, index) => ({
        ...val,
        id: `${index}`,
        index
      }));
      const newItem = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_content_fields_panel.ContentFieldsPanel, {
        contentFields: rules,
        editExistingField: id => {
          editExtractionRule(item);
          const rule = rules.find(({
            id: ruleId
          }) => id === ruleId);
          if (rule) {
            openEditRuleFlyout({
              fieldRule: rule,
              fieldRuleIndex: rule.index,
              isNewRule: false
            });
          }
        },
        editNewField: () => {
          editExtractionRule(item);
          openEditRuleFlyout({
            isNewRule: true
          });
        },
        removeField: id => {
          const rule = rules.find(({
            id: ruleId
          }) => id === ruleId);
          if (rule) {
            showDeleteFieldModal({
              extractionRuleId: item.id,
              fieldRuleIndex: rule.index
            });
          }
        }
      }));
      setItemIdToExpandedRowMap({
        ...itemIdToExpandedRowMap,
        [item.id]: newItem
      });
    }
  };
  const columns = [{
    field: 'description',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.descriptionTableLabel', {
      defaultMessage: 'Description'
    }),
    textOnly: true
  }, {
    field: 'url_filters',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.urlsLabel', {
      defaultMessage: 'URLs'
    }),
    render: filters => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      direction: "column",
      gutterSize: "xs"
    }, filters.length > 0 ? filters.map(({
      pattern
    }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, pattern))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '/*')))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.rulesLabel', {
      defaultMessage: 'Field rules'
    }),
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => toggleExpandedItem(rule)
    }, rule.rules.length),
    textOnly: true
  }, {
    field: 'updated_at',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.lastUpdatedLabel', {
      defaultMessage: 'Last updated'
    }),
    render: lastUpdated => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: lastUpdated
    }),
    textOnly: true
  }, {
    field: 'edited_by',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.editedByLabel', {
      defaultMessage: 'Edited by'
    }),
    render: editedBy => editedBy,
    textOnly: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.editRule.title', {
        defaultMessage: 'Edit this extraction rule'
      }),
      icon: 'pencil',
      isPrimary: false,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.editRule.caption', {
        defaultMessage: 'Edit this extraction rule'
      }),
      onClick: extractionRule => editExtractionRule(extractionRule),
      type: 'icon'
    }, {
      color: 'danger',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.deleteRule.title', {
        defaultMessage: 'Delete this extraction rule'
      }),
      icon: 'trash',
      isPrimary: false,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.deleteRule.caption', {
        defaultMessage: 'Delete extraction rule'
      }),
      onClick: extractionRule => showDeleteModal(extractionRule),
      type: 'icon'
    }, {
      color: 'primary',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.expandRule.title', {
        defaultMessage: 'Expand this extraction rule'
      }),
      icon: item => !!itemIdToExpandedRowMap[item.id] ? 'arrowUp' : 'arrowDown',
      isPrimary: true,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.expandRule.caption', {
        defaultMessage: 'Expand rule'
      }),
      onClick: extractionRule => toggleExpandedItem(extractionRule),
      type: 'icon'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.label', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteFieldModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    maxWidth: true,
    buttonColor: "danger",
    onCancel: hideDeleteFieldModal,
    onConfirm: deleteFieldRule,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteFieldModal.confirmLabel', {
      defaultMessage: 'Delete rule'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteFieldModal.title', {
      defaultMessage: 'Are you sure you want to delete this field rule?'
    }),
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteFieldModal.description', {
    defaultMessage: 'This action cannot be undone.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    isExpandable: true,
    itemId: "id",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: extractionRules,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.title', {
      defaultMessage: 'Crawl rules'
    })
  }));
};
exports.ExtractionRulesTable = ExtractionRulesTable;