"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtractionRulesLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../../common/types/api");
var _add_extraction_rule_api_logic = require("../../../../../api/crawler/extraction_rules/add_extraction_rule_api_logic");
var _delete_extraction_rule_api_logic = require("../../../../../api/crawler/extraction_rules/delete_extraction_rule_api_logic");
var _fetch_extraction_rules_api_logic = require("../../../../../api/crawler/extraction_rules/fetch_extraction_rules_api_logic");
var _update_extraction_rule_api_logic = require("../../../../../api/crawler/extraction_rules/update_extraction_rule_api_logic");
var _index_name_logic = require("../../../index_name_logic");
var _crawler_domain_detail_logic = require("../crawler_domain_detail_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExtractionRulesLogic = (0, _kea.kea)({
  actions: {
    cancelEditExtractionRule: true,
    closeEditRuleFlyout: true,
    deleteExtractionRule: true,
    deleteFieldRule: true,
    editExtractionRule: extractionRule => ({
      extractionRule
    }),
    editNewExtractionRule: true,
    hideDeleteFieldModal: true,
    hideDeleteModal: true,
    openEditRuleFlyout: ({
      fieldRule,
      isNewRule
    }) => ({
      fieldRule,
      isNewRule
    }),
    saveExtractionRule: extractionRule => ({
      extractionRule
    }),
    showDeleteFieldModal: ({
      fieldRuleIndex,
      extractionRuleId
    }) => ({
      extractionRuleId,
      fieldRuleIndex
    }),
    showDeleteModal: extractionRule => ({
      extractionRule
    })
  },
  connect: {
    actions: [_add_extraction_rule_api_logic.AddExtractionRuleApiLogic, ['makeRequest as addExtractionRule', 'apiSuccess as addExtractionRuleSuccess'], _crawler_domain_detail_logic.CrawlerDomainDetailLogic, ['receiveDomainData'], _delete_extraction_rule_api_logic.DeleteExtractionRuleApiLogic, ['makeRequest as deleteExtractionRuleRequest', 'apiSuccess as deleteExtractionRuleSuccess'], _fetch_extraction_rules_api_logic.FetchExtractionRulesApiLogic, ['makeRequest as fetchExtractionRules', 'apiSuccess as fetchExtractionRulesSuccess'], _update_extraction_rule_api_logic.UpdateExtractionRuleApiLogic, ['makeRequest as updateExtractionRule', 'apiSuccess as updateExtractionRuleSuccess']],
    values: [_add_extraction_rule_api_logic.AddExtractionRuleApiLogic, ['status as addStatus'], _crawler_domain_detail_logic.CrawlerDomainDetailLogic, ['domain', 'domainId', 'extractionRules as domainExtractionRules', 'getLoading as isLoading'], _delete_extraction_rule_api_logic.DeleteExtractionRuleApiLogic, ['status as deleteStatus'], _index_name_logic.IndexNameLogic, ['indexName'], _update_extraction_rule_api_logic.UpdateExtractionRuleApiLogic, ['status as updateStatus']]
  },
  events: ({
    actions,
    values
  }) => ({
    beforeUnmount: () => {
      // This prevents stale data from hanging around on unload
      actions.fetchDomainData(values.domainId);
    }
  }),
  listeners: ({
    actions,
    values
  }) => ({
    deleteExtractionRule: () => {
      if (values.extractionRuleToDelete) {
        var _values$extractionRul;
        actions.deleteExtractionRuleRequest({
          domainId: values.domainId,
          extractionRuleId: (_values$extractionRul = values.extractionRuleToDelete) === null || _values$extractionRul === void 0 ? void 0 : _values$extractionRul.id,
          indexName: values.indexName
        });
      }
    },
    deleteExtractionRuleSuccess: () => {
      actions.hideDeleteModal();
    },
    deleteFieldRule: () => {
      const {
        extractionRuleId,
        fieldRuleIndex
      } = values.fieldRuleToDelete;
      const extractionRule = values.extractionRules.find(({
        id
      }) => id === extractionRuleId);
      if (extractionRule) {
        const newFieldRules = extractionRule.rules.filter((_, index) => index !== fieldRuleIndex);
        actions.updateExtractionRule({
          domainId: values.domainId,
          indexName: values.indexName,
          rule: {
            ...extractionRule,
            rules: newFieldRules
          }
        });
      }
    },
    saveExtractionRule: ({
      extractionRule
    }) => {
      if (values.extractionRuleToEditIsNew) {
        actions.addExtractionRule({
          domainId: values.domainId,
          indexName: values.indexName,
          rule: extractionRule
        });
      } else if (values.extractionRuleToEdit) {
        actions.updateExtractionRule({
          domainId: values.domainId,
          indexName: values.indexName,
          rule: {
            ...values.extractionRuleToEdit,
            ...extractionRule
          }
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'crawler', 'extraction_rules'],
  reducers: () => ({
    deleteFieldModalVisible: [false, {
      hideDeleteFieldModal: () => false,
      showDeleteFieldModal: () => true,
      updateExtractionRuleSuccess: () => false
    }],
    deleteModalVisible: [false, {
      deleteExtractionRuleSuccess: () => false,
      hideDeleteModal: () => false,
      showDeleteModal: () => true
    }],
    editingExtractionRule: [false, {
      addExtractionRuleSuccess: () => false,
      cancelEditExtractionRule: () => false,
      editExtractionRule: () => true,
      editNewExtractionRule: () => true,
      updateExtractionRuleSuccess: () => false
    }],
    extractionRuleToDelete: [null, {
      deleteExtractionRuleSuccess: () => null,
      hideDeleteModal: () => null,
      showDeleteModal: (_, {
        extractionRule
      }) => extractionRule
    }],
    extractionRuleToEdit: [null, {
      addSuccess: () => null,
      cancelEditExtractionRule: () => null,
      editExtractionRule: (_, {
        extractionRule
      }) => extractionRule,
      updateSuccess: () => null,
      updateExtractionRuleSuccess: () => null
    }],
    extractionRuleToEditIsNew: [false, {
      addSuccess: () => false,
      editNewExtractionRule: () => true,
      editExtractionRule: () => false,
      updateExtractionRuleSuccess: () => false
    }],
    fieldRuleFlyoutVisible: [false, {
      addExtractionRuleSuccess: () => false,
      closeEditRuleFlyout: () => false,
      openEditRuleFlyout: () => true,
      updateExtractionRuleSuccess: () => false
    }],
    fieldRuleToDelete: [{}, {
      hideDeleteFieldModal: () => ({}),
      showDeleteFieldModal: (_, {
        extractionRuleId,
        fieldRuleIndex
      }) => ({
        extractionRuleId,
        fieldRuleIndex
      }),
      updateExtractionRuleSuccess: () => ({})
    }],
    fieldRuleToEdit: [null, {
      closeEditRuleFlyout: () => null,
      openEditRuleFlyout: (_, {
        fieldRule
      }) => fieldRule !== null && fieldRule !== void 0 ? fieldRule : null
    }],
    fieldRuleToEditIndex: [null, {
      closeEditRuleFlyout: () => null,
      openEditRuleFlyout: (_, {
        fieldRuleIndex
      }) => fieldRuleIndex !== null && fieldRuleIndex !== void 0 ? fieldRuleIndex : null
    }],
    fieldRuleToEditIsNew: [true, {
      closeEditRuleFlyout: () => true,
      openEditRuleFlyout: (_, {
        isNewRule
      }) => isNewRule
    }],
    updatedExtractionRules: [null, {
      addExtractionRuleSuccess: (_, {
        extraction_rules: extractionRules
      }) => extractionRules,
      deleteExtractionRuleSuccess: (_, {
        extraction_rules: extractionRules
      }) => extractionRules,
      receiveDomainData: () => null,
      updateExtractionRuleSuccess: (_, {
        extraction_rules: extractionRules
      }) => extractionRules
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    extractionRules: [() => [selectors.domainExtractionRules, selectors.updatedExtractionRules], (domainExtractionRules, updatedExtractionRules) => {
      var _ref;
      return (_ref = updatedExtractionRules !== null && updatedExtractionRules !== void 0 ? updatedExtractionRules : domainExtractionRules) !== null && _ref !== void 0 ? _ref : [];
    }],
    isLoadingUpdate: [() => [selectors.updateStatus, selectors.deleteStatus, selectors.addStatus], (updateStatus, deleteStatus, addStatus) => [updateStatus, deleteStatus, addStatus].includes(_api.Status.LOADING)]
  })
});
exports.ExtractionRulesLogic = ExtractionRulesLogic;