"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailsSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailsSummary = ({
  crawlDepth,
  crawlType,
  domainCount,
  stats
}) => {
  var _stats$status2, _stats$status3, _stats$status$urlsAll, _stats$status4, _stats$status5, _stats$status6;
  const duration = () => {
    var _stats$status;
    if (stats !== null && stats !== void 0 && (_stats$status = stats.status) !== null && _stats$status !== void 0 && _stats$status.crawlDurationMSec) {
      const milliseconds = _moment.default.duration(stats.status.crawlDurationMSec, 'milliseconds');
      const days = milliseconds.days();
      const hours = milliseconds.hours();
      const minutes = milliseconds.minutes();
      const seconds = milliseconds.seconds();
      return `${days ? days + 'd ' : ''}${hours}h ${minutes}m ${seconds}s`;
    } else {
      return '--';
    }
  };
  const getStatusCount = (code, codes) => {
    return Object.entries(codes).reduce((count, [k, v]) => {
      if (k[0] !== code) return count;
      return v + count;
    }, 0);
  };
  const statusCounts = {
    clientErrorCount: stats !== null && stats !== void 0 && (_stats$status2 = stats.status) !== null && _stats$status2 !== void 0 && _stats$status2.statusCodes ? getStatusCount('4', stats.status.statusCodes) : 0,
    serverErrorCount: stats !== null && stats !== void 0 && (_stats$status3 = stats.status) !== null && _stats$status3 !== void 0 && _stats$status3.statusCodes ? getStatusCount('5', stats.status.statusCodes) : 0
  };
  const shouldHideStats = !stats;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subjet": "crawlType",
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.components.crawlDetailsSummary.crawlCountOnDomains', {
      defaultMessage: '{crawlType} crawl on {domainCount, plural, one {# domain} other {# domains}}',
      values: {
        crawlType: crawlType[0].toUpperCase() + crawlType.substring(1),
        domainCount
      }
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.components.crawlDetailsSummary.crawlTypeLabel', {
      defaultMessage: 'Crawl type'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "crawlDepth",
    titleSize: "s",
    title: crawlDepth,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.components.crawlDetailsSummary.crawlDepthLabel', {
      defaultMessage: 'Max crawl depth'
    })
  })), !shouldHideStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "crawlDuration",
    titleSize: "s",
    title: duration(),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.durationTooltipTitle', {
      defaultMessage: 'Duration'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), !shouldHideStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "urlsAllowed",
    titleSize: "s",
    title: (_stats$status$urlsAll = stats === null || stats === void 0 ? void 0 : (_stats$status4 = stats.status) === null || _stats$status4 === void 0 ? void 0 : _stats$status4.urlsAllowed) !== null && _stats$status$urlsAll !== void 0 ? _stats$status$urlsAll : '--',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, "URLs", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      color: "primary",
      size: "m",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.urlsTooltipTitle', {
        defaultMessage: 'URLs Seen'
      }),
      content: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.urlsTooltip', {
        defaultMessage: 'URLs found by the crawler during the crawl, including those not followed due to the crawl configuration.'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "pagesVisited",
    titleSize: "s",
    title: stats !== null && stats !== void 0 && (_stats$status5 = stats.status) !== null && _stats$status5 !== void 0 && _stats$status5.pagesVisited ? stats.status.pagesVisited : '--',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.pagesVisitedTooltipTitle', {
      defaultMessage: 'Pages'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      color: "primary",
      size: "m",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.pagesTooltipTitle', {
        defaultMessage: 'Pages visited'
      }),
      content: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.pagesTooltip', {
        defaultMessage: 'URLs visited and extracted during the crawl.'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "avgResponseTime",
    titleSize: "s",
    title: stats !== null && stats !== void 0 && (_stats$status6 = stats.status) !== null && _stats$status6 !== void 0 && _stats$status6.avgResponseTimeMSec ? `${Math.round(stats.status.avgResponseTimeMSec)}ms` : '--',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.avgResponseTimeLabel', {
      defaultMessage: 'Avg. response'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "clientErrors",
    titleSize: "s",
    title: statusCounts.clientErrorCount,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.clientErrorsLabel', {
      defaultMessage: '4xx Errors'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "serverErrors",
    titleSize: "s",
    title: statusCounts.serverErrorCount,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.serverErrorsLabel', {
      defaultMessage: '5xx Errors'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center",
    "data-test-subj": "logsDisabledMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.crawler.crawlDetailsSummary.logsDisabledMessage",
    defaultMessage: "{configLink} in your enterprise-search.yml or user settings for more detailed crawl statistics.",
    values: {
      configLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.enterpriseSearchConfig,
        external: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlDetailsSummary.configLink', {
        defaultMessage: 'Enable web crawler logs'
      }))
    }
  }))));
};
exports.CrawlDetailsSummary = CrawlDetailsSummary;