"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticCrawlScheduler = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _enterprise_search_cron_editor = require("../../../../../shared/cron_editor/enterprise_search_cron_editor");
var _doc_links = require("../../../../../shared/doc_links/doc_links");
var _types = require("../../../../api/crawler/types");
var _indices = require("../../../../utils/indices");
var _automatic_crawl_scheduler_logic = require("./automatic_crawl_scheduler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomaticCrawlScheduler = () => {
  const {
    setCrawlAutomatically,
    setCrawlFrequency,
    setCrawlUnit,
    setUseConnectorSchedule,
    submitConnectorSchedule
  } = (0, _kea.useActions)(_automatic_crawl_scheduler_logic.AutomaticCrawlSchedulerLogic);
  const {
    index,
    crawlAutomatically,
    crawlFrequency,
    crawlUnit,
    useConnectorSchedule
  } = (0, _kea.useValues)(_automatic_crawl_scheduler_logic.AutomaticCrawlSchedulerLogic);
  if (!(0, _indices.isCrawlerIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.automaticCrawlSchedule.title', {
    defaultMessage: 'Crawl frequency'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-telemetry-id": "entSearchContent-crawler-scheduleCrawl-crawlAutomatically",
    autoFocus: true,
    checked: crawlAutomatically,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.crawlAutomaticallySwitchLabel', {
      defaultMessage: 'Enable recurring crawls with the following schedule'
    }),
    onChange: e => setCrawlAutomatically(e.target.checked),
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "specificTimeSchedulingCard",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.cronSchedulingTitle', {
      defaultMessage: 'Specific time scheduling'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.cronSchedulingDescription', {
      defaultMessage: 'Define the frequency and time for scheduled crawls. The crawler uses UTC as its timezone.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    })),
    checked: crawlAutomatically && useConnectorSchedule,
    disabled: !crawlAutomatically,
    onChange: () => setUseConnectorSchedule(true)
  }, /*#__PURE__*/_react.default.createElement(_enterprise_search_cron_editor.EnterpriseSearchCronEditor, {
    disabled: !crawlAutomatically || !useConnectorSchedule,
    scheduling: index.connector.scheduling,
    onChange: newScheduling => submitConnectorSchedule({
      ...newScheduling,
      enabled: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "intervalSchedulingCard",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.intervalSchedulingTitle', {
      defaultMessage: 'Interval scheduling'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.intervalSchedulingDescription', {
      defaultMessage: 'Define the frequency for scheduled crawls'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    })),
    checked: crawlAutomatically && !useConnectorSchedule,
    disabled: !crawlAutomatically,
    onChange: () => setUseConnectorSchedule(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: "Frequency",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-telemetry-id": "entSearchContent-crawler-scheduleCrawl-crawlAutomatically-scheduleFrequency",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.scheduleFrequencyLabel', {
      defaultMessage: 'Schedule frequency'
    }),
    disabled: !crawlAutomatically || useConnectorSchedule,
    min: 0,
    max: 99,
    compressed: true,
    value: crawlFrequency,
    onChange: e => setCrawlFrequency(parseInt(e.target.value, 10)),
    prepend: 'Every'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-telemetry-id": "entSearchContent-crawler-scheduleCrawl-crawlAutomatically-scheduleUnits",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.scheduleUnitsLabel', {
      defaultMessage: 'Schedule units of time'
    }),
    disabled: !crawlAutomatically || useConnectorSchedule,
    fullWidth: true,
    compressed: true,
    options: [{
      text: _constants.HOURS_UNIT_LABEL,
      value: _types.CrawlUnits.hours
    }, {
      text: _constants.DAYS_UNIT_LABEL,
      value: _types.CrawlUnits.days
    }, {
      text: _constants.WEEKS_UNIT_LABEL,
      value: _types.CrawlUnits.weeks
    }, {
      text: _constants.MONTHS_UNIT_LABEL,
      value: _types.CrawlUnits.months
    }],
    value: crawlUnit,
    onChange: e => setCrawlUnit(e.target.value)
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.scheduleDescription', {
    defaultMessage: 'The crawl schedule will perform a full crawl on every domain on this index.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.crawlerManaging,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.automaticCrawlSchedule.readMoreLink', {
    defaultMessage: 'Learn more about scheduling'
  }))))));
};
exports.AutomaticCrawlScheduler = AutomaticCrawlScheduler;