"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorTotalStats = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indices = require("../../utils/indices");
var _language_to_text = require("../../utils/language_to_text");
var _connector_overview_panels = require("./connector/connector_overview_panels");
var _constants = require("./connector/constants");
var _name_and_description_stats = require("./name_and_description_stats");
var _overview = require("./overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorTotalStats = () => {
  var _ref, _NATIVE_CONNECTORS$fi, _NATIVE_CONNECTORS$fi2, _indexData$connector$;
  const {
    indexData,
    isError,
    isLoading
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const hideStats = isLoading || isError;
  if (!(0, _indices.isConnectorIndex)(indexData)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const stats = [{
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.ingestionTypeCardLabel', {
      defaultMessage: 'Ingestion type'
    }),
    isLoading: hideStats,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.connectorIngestionMethodLabel', {
      defaultMessage: 'Connector'
    })
  }, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.connector.connectorTypePanel.title', {
      defaultMessage: 'Connector type'
    }),
    title: (_ref = (_NATIVE_CONNECTORS$fi = (_NATIVE_CONNECTORS$fi2 = _constants.NATIVE_CONNECTORS.find(connector => connector.serviceType === indexData.connector.service_type)) === null || _NATIVE_CONNECTORS$fi2 === void 0 ? void 0 : _NATIVE_CONNECTORS$fi2.name) !== null && _NATIVE_CONNECTORS$fi !== void 0 ? _NATIVE_CONNECTORS$fi : indexData.connector.service_type) !== null && _ref !== void 0 ? _ref : _i18n.i18n.translate('xpack.enterpriseSearch.connector.connectorTypePanel.unknown.label', {
      defaultMessage: 'Unknown'
    })
  }, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.languageLabel', {
      defaultMessage: 'Language analyzer'
    }),
    isLoading: hideStats,
    title: (0, _language_to_text.languageToText)((_indexData$connector$ = indexData.connector.language) !== null && _indexData$connector$ !== void 0 ? _indexData$connector$ : '')
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_name_and_description_stats.NameAndDescriptionStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, stats.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, (0, _extends2.default)({
    titleSize: "m"
  }, item)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_overview_panels.ConnectorOverviewPanels, null));
};
exports.ConnectorTotalStats = ConnectorTotalStats;