"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorAdvancedConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _index_name_logic = require("../../index_name_logic");
var _search_index = require("../../search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorAdvancedConfiguration = () => {
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnectorAdvancedConfiguration.description",
    defaultMessage: "Finalize your connector by triggering a one time sync, or setting a recurring sync schedule."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    "data-telemetry-id": "entSearchContent-connector-configuration-setScheduleAndSync",
    to: `${(0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
      indexName,
      tabId: _search_index.SearchIndexTabId.SCHEDULING
    })}`
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnectorAdvancedConfiguration.schedulingButtonLabel', {
    defaultMessage: 'Set schedule and sync'
  }))))));
};
exports.NativeConnectorAdvancedConfiguration = NativeConnectorAdvancedConfiguration;