"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertConnectorLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _convert_connector_api_logic = require("../../../../api/connector/convert_connector_api_logic");
var _index_view_logic = require("../../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConvertConnectorLogic = (0, _kea.kea)({
  actions: {
    convertConnector: () => true,
    deleteDomain: () => true,
    hideModal: () => true,
    showModal: () => true
  },
  connect: {
    actions: [_convert_connector_api_logic.ConvertConnectorApiLogic, ['apiError', 'apiSuccess', 'makeRequest'], _index_view_logic.IndexViewLogic, ['fetchIndex']],
    values: [_convert_connector_api_logic.ConvertConnectorApiLogic, ['status'], _index_view_logic.IndexViewLogic, ['connectorId']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    convertConnector: () => {
      if (values.connectorId) {
        actions.makeRequest({
          connectorId: values.connectorId
        });
      }
    }
  }),
  path: ['enterprise_search', 'convert_connector_modal'],
  reducers: {
    isModalVisible: [false, {
      apiError: () => false,
      apiSuccess: () => false,
      hideModal: () => false,
      showModal: () => true
    }]
  },
  selectors: ({
    selectors
  }) => ({
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING]
  })
});
exports.ConvertConnectorLogic = ConvertConnectorLogic;