"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertConnector = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _doc_links = require("../../../../../shared/doc_links");
var _convert_connector_logic = require("./convert_connector_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConvertConnector = () => {
  const {
    convertConnector,
    hideModal,
    showModal
  } = (0, _kea.useActions)(_convert_connector_logic.ConvertConnectorLogic);
  const {
    isLoading,
    isModalVisible
  } = (0, _kea.useValues)(_convert_connector_logic.ConvertConnectorLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: () => hideModal(),
    onConfirm: () => convertConnector(),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.indices.convertInfexConfirm.title', {
      defaultMessage: 'Sure you want to convert your connector?'
    }),
    buttonColor: "danger",
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.indices.convertIndexConfirm.text', {
      defaultMessage: 'Yes'
    }),
    isLoading: isLoading,
    defaultFocusedButton: "confirm",
    maxWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.indices.convertIndexConfirm.description', {
    defaultMessage: "Once you convert a native connector to a self-managed connector client this can't be undone."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "wrench"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.convertConnector.title', {
    defaultMessage: 'Customize your connector'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.convertConnector.description",
    defaultMessage: "Want to customize this native connector? Convert it to a {link}, to be self-managed on your own infrastructure.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.buildConnector,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.convertConnector.linkTitle', {
        defaultMessage: 'connector client'
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => showModal()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.convertConnector.buttonTitle', {
    defaultMessage: 'Convert connector'
  }))));
};
exports.ConvertConnector = ConvertConnector;