"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationConfig = () => {
  return /*#__PURE__*/_react.default.createElement(ConnectorConfigurationConfig, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.configurationConnector.config.description.firstParagraph",
    defaultMessage: "Now that your connector is deployed, enhance the connector client for your custom data source. There are several {link} you can customize with your own additional implementation logic.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://github.com/elastic/connectors-python/tree/main/connectors/sources",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.connectorClientLink', {
        defaultMessage: 'connectors'
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.description.secondParagraph', {
    defaultMessage: 'While the connector clients in the repository are built in Ruby, there’s no technical limitation to only use Ruby. Build a connector client with the technology that works best for your skillset.'
  })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.configurationConnector.config.description.thirdParagraph",
    defaultMessage: "If you need help, you can always open an {issuesLink} in the repository or ask a question in our {discussLink} forum.",
    values: {
      discussLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://discuss.elastic.co/c/enterprise-search/84",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.discussLink', {
        defaultMessage: 'Discuss'
      })),
      issuesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://github.com/elastic/connectors-python/issues",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.issuesLink', {
        defaultMessage: 'issue'
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.warning.title', {
      defaultMessage: 'This connector is tied to your Elastic index'
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.warning.description', {
    defaultMessage: 'If you sync at least one document before you’ve finalized your connector client, you will have to recreate your search index.'
  }))));
};
exports.ConnectorConfigurationConfig = ConnectorConfigurationConfig;