"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSchedulingLogic = void 0;
var _kea = require("kea");
var _update_connector_scheduling_api_logic = require("../../../api/connector/update_connector_scheduling_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSchedulingLogic = (0, _kea.kea)({
  actions: {
    setHasChanges: hasChanges => ({
      hasChanges
    })
  },
  connect: {
    actions: [_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic, ['apiSuccess']]
  },
  reducers: {
    hasChanges: [false, {
      apiSuccess: () => false,
      setHasChanges: (_, {
        hasChanges
      }) => hasChanges
    }]
  }
});
exports.ConnectorSchedulingLogic = ConnectorSchedulingLogic;