"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSchedulingComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _connectors = require("../../../../../../common/types/connectors");
var _cron_editor = require("../../../../shared/cron_editor");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _unsaved_changes_prompt = require("../../../../shared/unsaved_changes_prompt");
var _update_connector_scheduling_api_logic = require("../../../api/connector/update_connector_scheduling_api_logic");
var _routes = require("../../../routes");
var _types = require("../../../types");
var _indices = require("../../../utils/indices");
var _index_view_logic = require("../index_view_logic");
var _search_index = require("../search_index");
var _connector_scheduling_logic = require("./connector_scheduling_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSchedulingComponent = () => {
  var _connector, _schedulingInput$inte;
  const {
    index,
    ingestionStatus
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    status
  } = (0, _kea.useValues)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const {
    hasChanges
  } = (0, _kea.useValues)(_connector_scheduling_logic.ConnectorSchedulingLogic);
  const {
    setHasChanges
  } = (0, _kea.useActions)(_connector_scheduling_logic.ConnectorSchedulingLogic);

  // Need to do this ugly casting because we can't check this after the below typecheck, because useState can't be used after an if
  const schedulingInput = index === null || index === void 0 ? void 0 : (_connector = index.connector) === null || _connector === void 0 ? void 0 : _connector.scheduling;
  const [scheduling, setScheduling] = (0, _react.useState)(schedulingInput);
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: (_schedulingInput$inte = schedulingInput === null || schedulingInput === void 0 ? void 0 : schedulingInput.interval) !== null && _schedulingInput$inte !== void 0 ? _schedulingInput$inte : '',
    frequency: schedulingInput !== null && schedulingInput !== void 0 && schedulingInput.interval ? cronToFrequency(schedulingInput.interval) : 'HOUR'
  });
  if (!(0, _indices.isConnectorIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (index.connector.status === _connectors.ConnectorStatus.CREATED || index.connector.status === _connectors.ConnectorStatus.NEEDS_CONFIGURATION) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "iInCircle",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.title', {
        defaultMessage: 'Configure your connector to schedule a sync'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.description', {
      defaultMessage: 'Configure and deploy your connector, then return here to set your sync schedule. This schedule will dictate the interval that the connector will sync with your data source for updated documents.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      "data-telemetry-id": "entSearchContent-connector-scheduling-configure",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName: index.name,
        tabId: _search_index.SearchIndexTabId.CONFIGURATION
      }),
      fill: true,
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.button.label', {
      defaultMessage: 'Configure'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: hasChanges,
    messageText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.unsaved.title', {
      defaultMessage: 'You have not saved your changes, are you sure you want to leave?'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: "schedulingPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, ingestionStatus === _types.IngestionStatus.ERROR ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.error.title', {
      defaultMessage: 'Review your connector configuration for reported errors.'
    })
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: scheduling.enabled,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.switch.label', {
      defaultMessage: 'Enable recurring syncs with the following schedule'
    }),
    onChange: e => {
      setScheduling({
        ...scheduling,
        enabled: e.target.checked
      });
      setHasChanges(true);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.configured.description', {
    defaultMessage: 'Your connector is configured and deployed. Configure a one-time sync by clicking the Sync button, or enable a recurring sync schedule. The connector uses UTC as its timezone. '
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cron_editor.CronEditor, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-editSchedule",
    disabled: !scheduling.enabled,
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      setScheduling({
        ...scheduling,
        interval: expression
      });
      setHasChanges(true);
    },
    frequencyBlockList: ['MINUTE']
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-resetSchedule",
    disabled: !hasChanges || status === _api.Status.LOADING,
    onClick: () => {
      var _schedulingInput$inte2;
      setScheduling(schedulingInput);
      setSimpleCron({
        expression: (_schedulingInput$inte2 = schedulingInput === null || schedulingInput === void 0 ? void 0 : schedulingInput.interval) !== null && _schedulingInput$inte2 !== void 0 ? _schedulingInput$inte2 : '',
        frequency: schedulingInput !== null && schedulingInput !== void 0 && schedulingInput.interval ? cronToFrequency(schedulingInput.interval) : 'HOUR'
      });
      setHasChanges(false);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.resetButton.label', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-scheduling-saveSchedule",
    disabled: !hasChanges || status === _api.Status.LOADING,
    onClick: () => makeRequest({
      connectorId: index.connector.id,
      scheduling
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.saveButton.label', {
    defaultMessage: 'Save'
  }))))))));
};
exports.ConnectorSchedulingComponent = ConnectorSchedulingComponent;
function cronToFrequency(cron) {
  const fields = cron.split(' ');
  if (fields.length < 4) {
    return 'YEAR';
  }
  if (fields[1] === '*') {
    return 'MINUTE';
  }
  if (fields[2] === '*') {
    return 'HOUR';
  }
  if (fields[3] === '*') {
    return 'DAY';
  }
  if (fields[4] === '?') {
    return 'WEEK';
  }
  if (fields[4] === '*') {
    return 'MONTH';
  }
  return 'YEAR';
}