"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _connectors = require("../../../../../../common/types/connectors");
var _update_connector_configuration_api_logic = require("../../../api/connector/update_connector_configuration_api_logic");
var _connector_configuration_field = require("./connector_configuration_field");
var _connector_configuration_logic = require("./connector_configuration_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationForm = () => {
  const {
    status
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    localConfigView
  } = (0, _kea.useValues)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const {
    saveConfig,
    setIsEditing
  } = (0, _kea.useActions)(_connector_configuration_logic.ConnectorConfigurationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveConfig();
    },
    component: "form"
  }, localConfigView.map((configEntry, index) => {
    const {
      default_value: defaultValue,
      depends_on: dependencies,
      key,
      display,
      is_valid: isValid,
      label,
      sensitive,
      tooltip,
      validation_errors: validationErrors
    } = configEntry;
    const helpText = defaultValue ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.defaultValue', {
      defaultMessage: 'If left empty, the default value {defaultValue} will be used.',
      values: {
        defaultValue
      }
    }) : '';
    // toggle and sensitive textarea labels go next to the element, not in the row
    const rowLabel = display === _connectors.DisplayType.TOGGLE || display === _connectors.DisplayType.TEXTAREA && sensitive ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltip
    }, /*#__PURE__*/_react.default.createElement("p", null, label));
    if ((dependencies === null || dependencies === void 0 ? void 0 : dependencies.length) > 0) {
      // dynamic spacing without CSS
      const previousField = localConfigView[index - 1];
      const nextField = localConfigView[index + 1];
      const topSpacing = !previousField || previousField.depends_on.length <= 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      const bottomSpacing = !nextField || nextField.depends_on.length <= 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, topSpacing, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "subdued",
        borderRadius: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: rowLabel,
        key: key,
        helpText: helpText,
        error: validationErrors,
        isInvalid: !isValid,
        "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`
      }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
        configEntry: configEntry
      }))), bottomSpacing);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: rowLabel,
      key: key,
      helpText: helpText,
      error: validationErrors,
      isInvalid: !isValid,
      "data-test-subj": `entSearchContent-connector-configuration-formrow-${key}`
    }, /*#__PURE__*/_react.default.createElement(_connector_configuration_field.ConnectorConfigurationField, {
      configEntry: configEntry
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-configuration-saveConfiguration",
    type: "submit",
    isLoading: status === _api.Status.LOADING
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.submitButton.title', {
    defaultMessage: 'Save configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-configuration-cancelEdit",
    isDisabled: status === _api.Status.LOADING,
    onClick: () => {
      setIsEditing(false);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.cancelEditingButton.title', {
    defaultMessage: 'Cancel'
  }))))));
};
exports.ConnectorConfigurationForm = ConnectorConfigurationForm;