"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationField = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../common/types/api");
var _connectors = require("../../../../../../common/types/connectors");
var _update_connector_configuration_api_logic = require("../../../api/connector/update_connector_configuration_api_logic");
var _connector_configuration_logic = require("./connector_configuration_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationField = ({
  configEntry
}) => {
  const {
    status
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    setLocalConfigEntry
  } = (0, _kea.useActions)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const {
    key,
    display,
    is_valid: isValid,
    label,
    options,
    required,
    sensitive,
    tooltip,
    value
  } = configEntry;
  switch (display) {
    case _connectors.DisplayType.DROPDOWN:
      return options.length > 3 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        disabled: status === _api.Status.LOADING,
        options: options.map(option => ({
          text: option.label,
          value: option.value
        })),
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        disabled: status === _api.Status.LOADING,
        idSelected: (0, _connector_configuration_logic.ensureStringType)(value),
        name: "radio group",
        options: options.map(option => ({
          id: option.value,
          label: option.label
        })),
        onChange: id => {
          setLocalConfigEntry({
            ...configEntry,
            value: id
          });
        }
      });
    case _connectors.DisplayType.NUMERIC:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        disabled: status === _api.Status.LOADING,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        isInvalid: !isValid,
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      });
    case _connectors.DisplayType.TEXTAREA:
      const textarea = /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        disabled: status === _api.Status.LOADING,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      });
      return sensitive ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: key + '-accordion',
        buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: tooltip
        }, /*#__PURE__*/_react.default.createElement("p", null, label))
      }, textarea) : textarea;
    case _connectors.DisplayType.TOGGLE:
      const toggleLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltip
      }, /*#__PURE__*/_react.default.createElement("p", null, label));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        checked: (0, _connector_configuration_logic.ensureBooleanType)(value),
        disabled: status === _api.Status.LOADING,
        label: toggleLabel,
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.checked
          });
        }
      });
    default:
      return sensitive ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        disabled: status === _api.Status.LOADING,
        required: required,
        type: "dual",
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        disabled: status === _api.Status.LOADING,
        required: required,
        value: (0, _connector_configuration_logic.ensureStringType)(value),
        onChange: event => {
          setLocalConfigEntry({
            ...configEntry,
            value: event.target.value
          });
        }
      });
  }
};
exports.ConnectorConfigurationField = ConnectorConfigurationField;