"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _index_view_logic = require("../index_view_logic");
var _connector_configuration_form = require("./connector_configuration_form");
var _connector_configuration_logic = require("./connector_configuration_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationConfig = ({
  children
}) => {
  const {
    connectorError
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    configView,
    isEditing
  } = (0, _kea.useValues)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const {
    setIsEditing
  } = (0, _kea.useActions)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const displayList = configView.map(({
    label,
    sensitive,
    value
  }) => ({
    description: sensitive && !!value ? '********' : value || '--',
    title: label
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isEditing ? /*#__PURE__*/_react.default.createElement(_connector_configuration_form.ConnectorConfigurationForm, null) : displayList.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: displayList,
    className: "eui-textBreakWord"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-overview-configuration-editConfiguration",
    onClick: () => setIsEditing(!isEditing)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.editButton.title', {
    defaultMessage: 'Edit configuration'
  }))))))), !!connectorError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.error.title', {
      defaultMessage: 'Connector error'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, connectorError))));
};
exports.ConnectorConfigurationConfig = ConnectorConfigurationConfig;