"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _connectors = require("../../../../../../common/types/connectors");
var _beta_connector_callout = require("../../../../shared/beta/beta_connector_callout");
var _doc_links = require("../../../../shared/doc_links");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _generate_connector_api_key_api_logic = require("../../../api/connector/generate_connector_api_key_api_logic");
var _routes = require("../../../routes");
var _indices = require("../../../utils/indices");
var _index_name_logic = require("../index_name_logic");
var _index_view_logic = require("../index_view_logic");
var _search_index = require("../search_index");
var _api_key_configuration = require("./api_key_configuration");
var _connector_configuration_config = require("./connector_configuration_config");
var _connector_name_and_description = require("./connector_name_and_description/connector_name_and_description");
var _constants = require("./constants");
var _native_connector_configuration = require("./native_connector_configuration/native_connector_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfiguration = () => {
  var _index$connector$api_, _CONNECTORS$find;
  const {
    data: apiKeyData
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const {
    index,
    recheckIndexLoading
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    recheckIndex
  } = (0, _kea.useActions)(_index_view_logic.IndexViewLogic);
  if (!(0, _indices.isConnectorIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (index.connector.is_native && index.connector.service_type) {
    return /*#__PURE__*/_react.default.createElement(_native_connector_configuration.NativeConnectorConfiguration, null);
  }
  const hasApiKey = !!((_index$connector$api_ = index.connector.api_key_id) !== null && _index$connector$api_ !== void 0 ? _index$connector$api_ : apiKeyData);
  const docsUrl = (_CONNECTORS$find = _constants.CONNECTORS.find(({
    serviceType
  }) => serviceType === index.connector.service_type)) === null || _CONNECTORS$find === void 0 ? void 0 : _CONNECTORS$find.docsUrl;

  // TODO service_type === "" is considered unknown/custom connector multipleplaces replace all of them with a better solution
  const isBeta = !index.connector.service_type || Boolean(_constants.BETA_CONNECTORS.find(({
    serviceType
  }) => serviceType === index.connector.service_type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_api_key_configuration.ApiKeyConfig, {
        indexName: indexName,
        hasApiKey: !!index.connector.api_key_id
      }),
      status: hasApiKey ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.generateApiKey.title', {
        defaultMessage: 'Generate an API key'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_connector_name_and_description.ConnectorNameAndDescription, null),
      status: index.connector.description ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.nameAndDescriptionTitle', {
        defaultMessage: 'Name and description'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.description.secondParagraph",
        defaultMessage: "The connectors repository contains several {link}. Use our framework for accelerated development against custom data sources.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://github.com/elastic/connectors-python/tree/main/connectors",
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.clientExamplesLink', {
            defaultMessage: 'connector client examples'
          }))
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.description.thirdParagraph",
        defaultMessage: "In this step, you will need to clone or fork the repository, and copy the generated API key and connector ID to the associated {link}. The connector ID will identify this connector to Enterprise Search. The service type will determine which type of data source the connector is configured for.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://github.com/elastic/connectors-python/blob/main/config.yml",
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.configurationFileLink', {
            defaultMessage: 'configuration file'
          }))
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        fontSize: "m",
        paddingSize: "m",
        color: "dark",
        isCopyable: true
      }, `${apiKeyData !== null && apiKeyData !== void 0 && apiKeyData.encoded ? `elasticsearch:
  api_key: "${apiKeyData === null || apiKeyData === void 0 ? void 0 : apiKeyData.encoded}"
` : ''}connector_id: "${index.connector.id}"
service_type: "${index.connector.service_type || 'changeme'}"
`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.connectorDeployedText', {
        defaultMessage: 'Once you’ve configured the connector, deploy the connector to your self managed infrastructure.'
      }))),
      status: !index.connector.status || index.connector.status === _connectors.ConnectorStatus.CREATED ? 'incomplete' : 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.deployConnector.title', {
        defaultMessage: 'Deploy a connector'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_connector_configuration_config.ConnectorConfigurationConfig, null, !index.connector.status || index.connector.status === _connectors.ConnectorStatus.CREATED ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.waitingForConnectorTitle', {
          defaultMessage: 'Waiting for your connector'
        }),
        iconType: "iInCircle"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.waitingForConnectorText', {
        defaultMessage: 'Your connector has not connected to Enterprise Search. Troubleshoot your configuration and refresh the page.'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-configuration-recheckNow",
        iconType: "refresh",
        onClick: () => recheckIndex(),
        isLoading: recheckIndexLoading
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.waitingForConnector.button.label', {
        defaultMessage: 'Recheck now'
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "check",
        color: "success",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.connectorPackage.connectorConnected', {
          defaultMessage: 'Your connector {name} has connected to Enterprise Search successfully.',
          values: {
            name: index.connector.name
          }
        })
      })),
      status: index.connector.status === _connectors.ConnectorStatus.CONNECTED ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.enhance.title', {
        defaultMessage: 'Enhance your connector client'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.scheduleSync.description', {
        defaultMessage: 'Once configured, set a recurring sync schedule to keep your documents in sync over time. You can also simply trigger a one-time sync.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
        "data-telemetry-id": "entSearchContent-connector-configuration-setScheduleAndSync",
        to: `${(0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.SCHEDULING
        })}`
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.schedule.button.label', {
        defaultMessage: 'Set schedule and sync'
      })))))),
      status: index.connector.scheduling.enabled ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.steps.schedule.title', {
        defaultMessage: 'Set a recurring sync schedule'
      }),
      titleSize: 'xs'
    }]
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.title', {
    defaultMessage: 'Support and documentation'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.description', {
    defaultMessage: 'Your connector will have to be deployed to your own infrastructure.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.connectors,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.viewDocumentation.label', {
    defaultMessage: 'View documentation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: '/app/management/security/api_keys',
    shouldNotCreateHref: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.manageKeys.label', {
    defaultMessage: 'Manage keys'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://github.com/elastic/connectors-python/blob/main/README.md",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.readme.label', {
    defaultMessage: 'Connector readme'
  }))), docsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docsUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.dockerDeploy.label', {
    defaultMessage: 'Deploy with Docker'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://github.com/elastic/connectors-python/blob/main/docs/CONFIG.md#run-the-connector-service-for-a-custom-connector",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.support.deploy.label', {
    defaultMessage: 'Deploy without Docker'
  })))))), isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null)) : null))));
};
exports.ConnectorConfiguration = ConnectorConfiguration;