"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncsContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../../common/types/api");
var _cancel_syncs_api_logic = require("../../../../api/connector/cancel_syncs_api_logic");
var _types = require("../../../../types");
var _cancel_syncs_logic = require("../../connector/cancel_syncs_logic");
var _index_view_logic = require("../../index_view_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncsContextMenu = () => {
  const {
    ingestionMethod,
    ingestionStatus,
    isCanceling,
    isSyncing,
    isWaitingForSync
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    cancelSyncs
  } = (0, _kea.useActions)(_cancel_syncs_logic.CancelSyncsLogic);
  const {
    status
  } = (0, _kea.useValues)(_cancel_syncs_api_logic.CancelSyncsApiLogic);
  const {
    startSync
  } = (0, _kea.useActions)(_index_view_logic.IndexViewLogic);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = () => setPopover(!isPopoverOpen);
  const closePopover = () => setPopover(false);
  const getSyncButtonText = () => {
    if (isWaitingForSync) {
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncButton.waitingForSync.label', {
        defaultMessage: 'Waiting for sync'
      });
    }
    if (isSyncing && ingestionStatus !== _types.IngestionStatus.ERROR) {
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncButton.syncing.label', {
        defaultMessage: 'Syncing'
      });
    }
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncButton.label', {
      defaultMessage: 'Sync'
    });
  };
  const syncLoading = (isSyncing || isWaitingForSync) && ingestionStatus !== _types.IngestionStatus.ERROR;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-sync-openSyncMenu`,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover,
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s"
    }, syncLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getSyncButtonText()))),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [...(syncLoading ? [] : [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-sync-startSync`,
      disabled: ingestionStatus === _types.IngestionStatus.INCOMPLETE,
      key: "Sync",
      onClick: () => {
        closePopover();
        startSync();
      },
      icon: "play"
    }, getSyncButtonText())]), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-sync-cancelSync`,
      disabled: isCanceling && ingestionStatus !== _types.IngestionStatus.ERROR || status === _api.Status.LOADING,
      key: "Cancel sync",
      onClick: () => {
        closePopover();
        cancelSyncs();
      },
      icon: "trash"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.index.header.cancelSyncsTitle', {
      defaultMessage: 'Cancel Syncs'
    }))]
  }));
};
exports.SyncsContextMenu = SyncsContextMenu;