"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchEnginesPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _routes = require("../../../../../applications/routes");
var _kibana = require("../../../../../shared/kibana");
var _create_engine_menu_item = require("./create_engine_menu_item");
var _search_engines_popover_logic = require("./search_engines_popover_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchEnginesPopover = ({
  indexName,
  ingestionMethod,
  isHiddenIndex
}) => {
  const {
    isSearchEnginesPopoverOpen
  } = (0, _kea.useValues)(_search_engines_popover_logic.SearchEnginesPopoverLogic);
  const {
    toggleSearchEnginesPopover
  } = (0, _kea.useActions)(_search_engines_popover_logic.SearchEnginesPopoverLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isSearchEnginesPopoverOpen,
    closePopover: toggleSearchEnginesPopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-searchEngines`,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: toggleSearchEnginesPopover
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.searchEngines.label', {
      defaultMessage: 'Search Applications'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-searchEngines-viewEngines`,
      icon: "eye",
      onClick: () => {
        _kibana.KibanaLogic.values.navigateToUrl(_constants.APPLICATIONS_PLUGIN.URL + _routes.ENGINES_PATH, {
          shouldNotCreateHref: true
        });
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.searchEngines.viewEngines', {
      defaultMessage: 'View Search Applications'
    })))), isHiddenIndex ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.searchEngines.createEngineDisabledTooltip', {
        defaultMessage: 'You cannot create search applications from hidden indices.'
      })
    }, /*#__PURE__*/_react.default.createElement(_create_engine_menu_item.CreateEngineMenuItem, {
      indexName: indexName,
      ingestionMethod: ingestionMethod,
      isHiddenIndex: isHiddenIndex
    })) : /*#__PURE__*/_react.default.createElement(_create_engine_menu_item.CreateEngineMenuItem, {
      indexName: indexName,
      ingestionMethod: ingestionMethod,
      isHiddenIndex: isHiddenIndex
    })]
  }));
};
exports.SearchEnginesPopover = SearchEnginesPopover;