"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurlRequest = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cloud_details = require("../../../../../shared/cloud_details/cloud_details");
var _decode_cloud_id = require("../../../../../shared/decode_cloud_id/decode_cloud_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurlRequest = ({
  indexName,
  apiKey,
  document,
  pipeline
}) => {
  var _decodeCloudId;
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const DEFAULT_URL = 'https://localhost:9200';
  const baseUrl = cloudContext.cloudId && ((_decodeCloudId = (0, _decode_cloud_id.decodeCloudId)(cloudContext.cloudId)) === null || _decodeCloudId === void 0 ? void 0 : _decodeCloudId.elasticsearchUrl) || DEFAULT_URL;
  const apiKeyExample = apiKey || '<Replace_with_created_API_key>';
  const {
    name: pipelineName,
    ...pipelineParams
  } = pipeline !== null && pipeline !== void 0 ? pipeline : {};
  // We have to prefix the parameters with an underscore because that's what the actual pipeline looks for
  const pipelineArgs = Object.entries(pipelineParams).reduce((acc, curr) => ({
    ...acc,
    [`_${curr[0]}`]: curr[1]
  }), {});
  const inputDocument = pipeline ? {
    ...document,
    ...pipelineArgs
  } : document;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    fontSize: "m",
    isCopyable: true
  }, `\
curl -X POST '${baseUrl}/${indexName}/_doc${pipeline ? `?pipeline=${pipelineName}` : ''}' \\
  -H 'Content-Type: application/json' \\
  -H 'Authorization: ApiKey ${apiKeyExample}' \\
  -d '${JSON.stringify(inputDocument, null, 2)}'
`);
};
exports.CurlRequest = CurlRequest;