"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _constants2 = require("../../../../shared/constants");
var _doc_links = require("../../../../shared/doc_links");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _query_params = require("../../../../shared/query_params");
var _routes = require("../../../routes");
var _layout = require("../../layout");
var _constants3 = require("../../search_index/connector/constants");
var _search_indices = require("../../search_indices");
var _connector_checkable = require("./connector_checkable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectConnector = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    service_type: serviceType
  } = (0, _query_params.parseQueryParams)(search);
  const [selectedConnector, setSelectedConnector] = (0, _react.useState)(Array.isArray(serviceType) ? serviceType[0] : serviceType !== null && serviceType !== void 0 ? serviceType : null);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const hasNativeAccess = isCloud || hasPlatinumLicense;
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, 'Select connector'],
    pageViewTelemetry: "select_connector",
    isLoading: false,
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.description', {
        defaultMessage: "Choose which third-party data source you'd like to sync to Elastic."
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.title', {
        defaultMessage: 'Select a connector'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: event => {
      event.preventDefault();
      _kibana.KibanaLogic.values.navigateToUrl(`${(0, _encode_path_params.generateEncodedPath)(_routes.NEW_INDEX_METHOD_PATH, {
        type: _constants.INGESTION_METHOD_IDS.CONNECTOR
      })}?service_type=${selectedConnector}`);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "m",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.callout.title', {
          defaultMessage: 'Elastic connectors'
        }),
        iconType: "iInCircle"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.selectConnector.description.textcloud",
        defaultMessage: "{native} are available directly within Elastic Cloud deployments. No additional infrastructure is required. Self-managed deployments must deploy the connector service to run native connectors. {learnMore}",
        values: {
          learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            href: _doc_links.docLinks.connectorsNative
          }, _constants2.LEARN_MORE_LINK),
          native: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.callout.description.native', {
            defaultMessage: 'Native connectors'
          }))
        }
      }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.selectConnector.description.selfManaged.text",
        defaultMessage: "For advanced use cases, deploy {connectorsClient} on your own infrastructure. Customize existing connectors, or build your own using our connector framework. {learnMore}",
        values: {
          connectorsClient: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.callout.description.connectorsClient', {
            defaultMessage: 'connector clients'
          })),
          learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            href: _doc_links.docLinks.connectorsClients
          }, _constants2.LEARN_MORE_LINK)
        }
      })))
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, _constants3.CONNECTORS.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: connector.serviceType,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_connector_checkable.ConnectorCheckable, {
    icon: connector.icon,
    isBeta: connector.isBeta,
    isTechPreview: Boolean(connector.isTechPreview),
    showNativeBadge: connector.isNative && hasNativeAccess,
    name: connector.name,
    serviceType: connector.serviceType,
    onChange: () => {
      setSelectedConnector(connector.serviceType);
    },
    documentationUrl: connector.docsUrl,
    checked: selectedConnector === connector.serviceType
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-selectConnector-backButton",
    color: "primary",
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_PATH)
  }, _constants2.BACK_BUTTON_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-selectConnector-selectAndConfigure",
    disabled: selectedConnector === null,
    fill: true,
    color: "primary",
    type: "submit"
  }, _constants2.CONTINUE_BUTTON_LABEL)))))));
};
exports.SelectConnector = SelectConnector;