"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana_logic = require("../../../shared/kibana/kibana_logic");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _search_indices = require("../search_indices");
var _new_index_card = require("./new_index_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAvailableMethodOptions = productFeatures => {
  return [...(productFeatures.hasWebCrawler ? [_constants.INGESTION_METHOD_IDS.CRAWLER] : []), ...(productFeatures.hasConnectors ? [_constants.INGESTION_METHOD_IDS.CONNECTOR] : []), _constants.INGESTION_METHOD_IDS.API];
};
const NewIndex = () => {
  const {
    capabilities,
    productFeatures
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const availableIngestionMethodOptions = getAvailableMethodOptions(productFeatures);
  const [selectedMethod, setSelectedMethod] = (0, _react.useState)('');
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.breadcrumb', {
      defaultMessage: 'New ingestion method'
    })],
    pageViewTelemetry: "New Index",
    isLoading: false,
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.pageDescription', {
        defaultMessage: 'Create a search optimized Elasticsearch index to store your content. Start by selecting an ingestion method.'
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.pageTitle', {
        defaultMessage: 'Select an ingestion method'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, availableIngestionMethodOptions.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: type
  }, /*#__PURE__*/_react.default.createElement(_new_index_card.NewIndexCard, {
    type: type,
    onSelect: () => {
      setSelectedMethod(type);
      if (type === _constants.INGESTION_METHOD_IDS.CONNECTOR) {
        _kibana_logic.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_PATH);
      } else {
        _kibana_logic.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.NEW_INDEX_METHOD_PATH, {
          type
        }));
      }
    },
    isSelected: selectedMethod === type
  }))))), capabilities.navLinks.integrations && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: "/app/integrations",
    shouldNotCreateHref: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.viewIntegrationsLink', {
    defaultMessage: 'View additional integrations'
  }))))));
};
exports.NewIndex = NewIndex;