"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _licensing_callout = require("../../../../shared/licensing_callout/licensing_callout");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _fetch_cloud_health_api_logic = require("../../../api/stats/fetch_cloud_health_api_logic");
var _constants = require("../../search_index/connector/constants");
var _new_search_index_logic = require("../new_search_index_logic");
var _new_search_index_template = require("../new_search_index_template");
var _error_to_text = require("../utils/error_to_text");
var _add_connector_logic = require("./add_connector_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodConnector = ({
  serviceType
}) => {
  const {
    apiReset,
    makeRequest
  } = (0, _kea.useActions)(_add_connector_api_logic.AddConnectorApiLogic);
  const {
    error,
    status
  } = (0, _kea.useValues)(_add_connector_api_logic.AddConnectorApiLogic);
  const {
    isModalVisible
  } = (0, _kea.useValues)(_add_connector_logic.AddConnectorLogic);
  const {
    setIsModalVisible
  } = (0, _kea.useActions)(_add_connector_logic.AddConnectorLogic);
  const {
    fullIndexName,
    language
  } = (0, _kea.useValues)(_new_search_index_logic.NewSearchIndexLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isNative = Boolean(_constants.NATIVE_CONNECTORS.find(connector => connector.serviceType === serviceType)) && (isCloud || hasPlatinumLicense);
  const isBeta = Boolean(_constants.BETA_CONNECTORS.find(connector => connector.serviceType === serviceType));
  const isGated = isNative && !isCloud && !hasPlatinumLicense;
  const {
    makeRequest: fetchCloudHealth
  } = (0, _kea.useActions)(_fetch_cloud_health_api_logic.FetchCloudHealthApiLogic);
  (0, _react.useEffect)(() => {
    if (isCloud) {
      fetchCloudHealth({});
    }
  }, [isCloud]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.NATIVE_CONNECTOR
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_new_search_index_template.NewSearchIndexTemplate, {
    docsUrl: _doc_links.docLinks.connectors,
    disabled: isGated,
    error: (0, _error_to_text.errorToText)(error),
    type: "connector",
    onNameChange: () => {
      apiReset();
    },
    onSubmit: (name, lang) => makeRequest({
      indexName: name,
      isNative,
      language: lang,
      serviceType
    }),
    buttonLoading: status === _api.Status.LOADING,
    isBeta: isBeta
  }), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.confirmModal.title', {
      defaultMessage: 'Replace existing connector'
    }),
    onCancel: () => {
      setIsModalVisible(false);
    },
    onConfirm: () => {
      makeRequest({
        deleteExistingConnector: true,
        indexName: fullIndexName,
        isNative,
        language,
        serviceType
      });
    },
    cancelButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.confirmModal.cancelButton.label', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.confirmModal.confirmButton.label', {
      defaultMessage: 'Replace configuration'
    }),
    defaultFocusedButton: "confirm"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.confirmModal.description', {
    defaultMessage: 'A deleted index named {indexName} was originally tied to an existing connector configuration. Would you like to replace the existing connector configuration with a new one?',
    values: {
      indexName: fullIndexName
    }
  }))));
};
exports.MethodConnector = MethodConnector;