"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchDocuments = exports.SearchDocumentsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchDocuments = async ({
  docsPerPage,
  indexName,
  pagination,
  query: searchQuery
}) => {
  const newIndexName = encodeURIComponent(indexName);
  const route = `/internal/enterprise_search/indices/${newIndexName}/search`;
  const query = {
    page: pagination.pageIndex,
    size: docsPerPage || pagination.pageSize
  };
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      searchQuery
    }),
    query
  });
};
exports.searchDocuments = searchDocuments;
const SearchDocumentsApiLogic = (0, _create_api_logic.createApiLogic)(['search_documents_api_logic'], searchDocuments);
exports.SearchDocumentsApiLogic = SearchDocumentsApiLogic;