"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detachMlInferencePipeline = exports.DetachMlInferencePipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detachMlInferencePipeline = async args => {
  const route = `/internal/enterprise_search/indices/${args.indexName}/ml_inference/pipeline_processors/${args.pipelineName}/detach`;
  return await _http.HttpLogic.values.http.delete(route);
};
exports.detachMlInferencePipeline = detachMlInferencePipeline;
const DetachMlInferencePipelineApiLogic = (0, _create_api_logic.createApiLogic)(['detach_ml_inference_pipeline_api_logic'], detachMlInferencePipeline);
exports.DetachMlInferencePipelineApiLogic = DetachMlInferencePipelineApiLogic;