"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTextExpansionModel = exports.CreateTextExpansionModelApiLogic = void 0;
var _ml_inference_pipeline = require("../../../../../../common/ml_inference_pipeline");
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTextExpansionModel = async () => {
  const route = `/internal/enterprise_search/ml/models/${_ml_inference_pipeline.ELSER_MODEL_ID}`;
  return await _http.HttpLogic.values.http.post(route, {
    body: undefined
  });
};
exports.createTextExpansionModel = createTextExpansionModel;
const CreateTextExpansionModelApiLogic = (0, _create_api_logic.createApiLogic)(['create_text_expansion_model_api_logic'], createTextExpansionModel, {
  showErrorFlash: false
});
exports.CreateTextExpansionModelApiLogic = CreateTextExpansionModelApiLogic;