"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMLModelsStats = exports.MLModelsStatsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMLModelsStats = async () => {
  return await _http.HttpLogic.values.http.get('/api/ml/trained_models/_stats');
};
exports.getMLModelsStats = getMLModelsStats;
const MLModelsStatsApiLogic = (0, _create_api_logic.createApiLogic)(['ml_models_stats_api_logic'], getMLModelsStats, {
  clearFlashMessagesOnMakeRequest: false,
  showErrorFlash: false
});
exports.MLModelsStatsApiLogic = MLModelsStatsApiLogic;