"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMappings = exports.MappingsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappings = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/mappings/${indexName}`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.getMappings = getMappings;
const MappingsApiLogic = (0, _create_api_logic.createApiLogic)(['mappings_api_logic'], getMappings);
exports.MappingsApiLogic = MappingsApiLogic;