"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorScheduling = exports.UpdateConnectorSchedulingApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateConnectorScheduling = async ({
  connectorId,
  scheduling: {
    enabled,
    interval
  }
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/scheduling`;
  await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      enabled,
      interval
    })
  });
  return {
    enabled,
    interval
  };
};
exports.updateConnectorScheduling = updateConnectorScheduling;
const UpdateConnectorSchedulingApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'update_connector_scheduling_api_logic'], updateConnectorScheduling, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.scheduling.successToast.title', {
    defaultMessage: 'Scheduling successfully updated'
  })
});
exports.UpdateConnectorSchedulingApiLogic = UpdateConnectorSchedulingApiLogic;