"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchCloudId = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloud_details = require("../../../shared/cloud_details/cloud_details");
var _http = require("../../../shared/http");
var _telemetry = require("../../../shared/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onFocusHandler = e => {
  e.target.select();
};
const copyCloudIdHandler = (copy, sendTelemetry) => {
  return () => {
    copy();
    sendTelemetry({
      action: 'clicked',
      metric: 'cloud_id'
    });
  };
};
const ElasticsearchCloudId = () => {
  const cloud = (0, _cloud_details.useCloudDetails)();
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);

  // hide the panel when no cloud context is available
  if (!cloud.cloudId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    grow: false,
    "data-test-subj": "CloudIdPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchCloudId.heading', {
    defaultMessage: 'My Deployment'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: cloud.deploymentUrl,
    target: "_blank",
    "data-test-subj": "cloudManageLink"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchCloudId.manageLink', {
    defaultMessage: 'Manage'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchCloudId.cloudIdLabel', {
      defaultMessage: 'Cloud ID'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onFocus: onFocusHandler,
    value: cloud.cloudId,
    compressed: true,
    readOnly: true,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: cloud.cloudId
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'copyClipboard',
      onClick: copyCloudIdHandler(copy, sendEnterpriseSearchTelemetry),
      iconSize: "m",
      "data-test-subj": "CopyCloudIdButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchCloudId.copyCloudIdAriaLabel', {
        defaultMessage: 'Copy Cloud ID'
      })
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: `${http.basePath.publicBaseUrl}/app/management/security/api_keys`
  }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.elasticsearchCloudId.manageApiKeysLink', {
    defaultMessage: 'Manage API keys'
  })))));
};
exports.ElasticsearchCloudId = ElasticsearchCloudId;