"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchRuby = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchRuby = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch"), ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "http://rubygems.org/gems/elasticsearch"
  }, "Rubygem"), ' ', "provides a low-level client for communicating with an Elasticsearch cluster, fully compatible with other official clients."), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsRubyOverview
  }, "Learn more about the Ruby client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-ruby"
  }, "The Elasticsearch Ruby client on Github"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "http://rubydoc.info/gems/elasticsearch"
  }, "The Elasticsearch Ruby client on RubyDoc"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, "Check out these other official Ruby libraries for working with Elasticsearch:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://github.com/elasticsearch/elasticsearch-rails"
  }, "elasticsearch-rails"), ' ', "- integration with Ruby models and Rails applications."), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://github.com/elastic/elasticsearch-ruby/tree/7.17/elasticsearch-extensions"
  }, "elasticsearch-extensions"), ", deprecated."), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://github.com/elastic/elasticsearch-dsl-ruby"
  }, "elasticsearch-dsl"), ' ', "which provides a Ruby API for the", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.queryDsl
  }, "Elasticsearch Query DSL"), "."))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "Install the ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch"), " gem from Rubygems:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          $ gem install elasticsearch
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "Or add it to your project\u2019s Gemfile:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true
  }, (0, _dedent.default)`
          gem 'elasticsearch', '<ELASTICSEARCH_VERSION>'
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "If you are using Elastic Cloud, the client offers an easy way to connect to it. You must pass the Cloud ID that you can find in the cloud console."), /*#__PURE__*/_react.default.createElement("p", null, "You can connect to Elastic Cloud using ", /*#__PURE__*/_react.default.createElement("strong", null, "Basic authentication"), " or an", ' ', /*#__PURE__*/_react.default.createElement("strong", null, "API key"), ". Where ", '<cloud-id>', " is reported in the Deployment UI. For basic authentication, ", '<username>', " and ", '<password>', " are generated when you deploy a new cloud instance. You\u2019ll need to store the ", '<username>', " and ", '<password>', " since they will not be available via UI.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "ruby"
  }, (0, _dedent.default)`
              require 'elasticsearch'

              // Connect via basic authentication
              client = Elasticsearch::Client.new(
                cloud_id: '${cloudId}'
                user: '<Username>',
                password: '<Password>',
              )
              
              // Connect via API key
              client = Elasticsearch::Client.new( 
                cloud_id: '${cloudId}', 
                api_key: {id: '<Id>', api_key: '<APIKey>'} 
              )
            `)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "There are several ways to authenticate to Elasticsearch running outside of Cloud, including API keys, bearer tokens, and basic authentication.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsRubyAuthentication
  }, "Visit the client\u2019s documentation to learn more"), "."))));
};
exports.ElasticsearchRuby = ElasticsearchRuby;