"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchPython = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchPython = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "elasticsearch-py, the official Python client for Elasticsearch, is a low-level client for interacting with Elasticsearch\u2019s REST API. It\u2019s designed to be unopinionated and extendable."), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsPythonOverview
  }, "Learn more about the Python client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://elasticsearch-py.readthedocs.io/"
  }, "The Python client for Elasticsearch on Read the Docs"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-py"
  }, "elasticsearch-py on Github")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "Install the ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch"), " package with", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://pypi.org/project/elasticsearch"
  }, "pip"), ":")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          $ python -m pip install elasticsearch
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "If your application uses async/await in Python you can install the client with the async extra:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          $ python -m pip install elasticsearch[async]
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "Learn more about", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://pypi.org/project/elasticsearch"
  }, "using asyncio with this project"), ".")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "Cloud ID is an easy way to configure your client to work with your Elastic Cloud deployment. Combine the cloud_id with either basic_auth or api_key to authenticate with your Elastic Cloud deployment."), /*#__PURE__*/_react.default.createElement("p", null, "Using cloud_id enables TLS verification and HTTP compression by default and sets the port to 443 unless otherwise overwritten via the port parameter or the port value encoded within cloud_id. Using Cloud ID also disables sniffing as a proxy is in use.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "python"
  }, (0, _dedent.default)`
              from elasticsearch import Elasticsearch

              es = Elasticsearch(
                  cloud_id="${cloudId}"
              )              
            `)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "A single node can be specified via a ", /*#__PURE__*/_react.default.createElement("code", null, "scheme"), ", ", /*#__PURE__*/_react.default.createElement("code", null, "host"), ",", ' ', /*#__PURE__*/_react.default.createElement("code", null, "port"), ", and optional ", /*#__PURE__*/_react.default.createElement("code", null, "path_prefix"), ". These values can either be specified manually via a URL in a string, dictionary,", /*#__PURE__*/_react.default.createElement("code", null, "NodeConfig"), ", or a list of these values. You must specify at least", ' ', /*#__PURE__*/_react.default.createElement("code", null, "scheme"), ", ", /*#__PURE__*/_react.default.createElement("code", null, "host"), " and ", /*#__PURE__*/_react.default.createElement("code", null, "port"), "for each node. All of the following are valid configurations:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "python"
  }, (0, _dedent.default)`
              from elasticsearch import Elasticsearch

              # Single node via URL
              es = Elasticsearch("http://localhost:9200")
              
              # Multiple nodes via URL
              es = Elasticsearch([
                  "http://localhost:9200",
                  "http://localhost:9201",
                  "http://localhost:9202"
              ])
              
              # Single node via dictionary
              es = Elasticsearch({"scheme": "http", "host": "localhost", "port": 9200})
              
              # Multiple nodes via dictionary
              es = Elasticsearch([
                  {"scheme": "http", "host": "localhost", "port": 9200},
                  {"scheme": "http", "host": "localhost", "port": 9201},
              ])
            `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "There are several ways to authenticate to Elasticsearch running outside of Cloud, including API keys, bearer tokens, and basic authentication.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsPythonAuthentication
  }, "Visit the client\u2019s documentation to learn more"), "."))));
};
exports.ElasticsearchPython = ElasticsearchPython;