"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchJavascript = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchJavascript = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "This is the official Node.js client for Elasticsearch includes all the features you need to add search to any Node.js application:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "One-to-one mapping with REST API."), /*#__PURE__*/_react.default.createElement("li", null, "Generalized, pluggable architecture."), /*#__PURE__*/_react.default.createElement("li", null, "Configurable, automatic discovery of cluster nodes."), /*#__PURE__*/_react.default.createElement("li", null, "Persistent, Keep-Alive connections."), /*#__PURE__*/_react.default.createElement("li", null, "Load balancing across all available nodes."), /*#__PURE__*/_react.default.createElement("li", null, "Child client support."), /*#__PURE__*/_react.default.createElement("li", null, "TypeScript support out of the box.")), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsJsIntro
  }, "Learn more about the official Node.js client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-js"
  }, "The official Node.js client for Elasticsearch on Github")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "To install the latest version of the client, run the following command:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, "npm install @elastic/elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "If you are using Elastic Cloud, the client offers an easy way to connect to it via the cloud option. You must pass the Cloud ID that you can find in the cloud console, then your username and password inside the auth option.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "javascript"
  }, (0, _dedent.default)`
              const { Client } = require('@elastic/elasticsearch')
              const client = new Client({
                cloud: {
                  id: '${cloudId}',
                },
                auth: {
                  username: '<username>',
                  password: '<password>'
                }
              })`)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "There are several ways to connect and authenticate to Elasticsearch running outside of Cloud, including API keys, bearer tokens, and basic authentication.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsJsClientConnecting
  }, "Visit the client\u2019s documentation to learn more"), "."))));
};
exports.ElasticsearchJavascript = ElasticsearchJavascript;