"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchDotnet = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchDotnet = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The official .Net client for Elasticsearch includes all the features you need to add search to a .Net application:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "One-to-one mapping with REST API."), /*#__PURE__*/_react.default.createElement("li", null, "Strongly typed requests and responses for Elasticsearch APIs."), /*#__PURE__*/_react.default.createElement("li", null, "Fluent API for building requests."), /*#__PURE__*/_react.default.createElement("li", null, "Helpers for common tasks such as bulk indexing of documents."), /*#__PURE__*/_react.default.createElement("li", null, "Pluggable serialization of requests and responses based on System.Text.Json."), /*#__PURE__*/_react.default.createElement("li", null, "Diagnostics, auditing, and .NET activity integration.")), /*#__PURE__*/_react.default.createElement("p", null, "The .NET Elasticsearch client is built upon the Elastic Transport library which provides:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "Connection management and load balancing across all available nodes."), /*#__PURE__*/_react.default.createElement("li", null, "Request retries and dead connections handling.")), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsNetIntroduction
  }, "Learn more about the official .NET clients for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-net"
  }, "The official Elasticsearch .NET clients on Github")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "For SDK style projects, you can install the Elasticsearch client by running the following .NET CLI command in your terminal:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          dotnet add package Elastic.Clients.Elasticsearch
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "This command adds a package reference to your project (csproj) file for the latest stable version of the client."), /*#__PURE__*/_react.default.createElement("p", null, "If you prefer, you may also manually add a package reference inside your project file:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          <PackageReference Include="Elastic.Clients.Elasticsearch" Version="ELASTICSAERCH VERSION" />
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "For Visual Studio users, the .NET client can also be installed from the Package Manager Console inside Visual Studio using the following command:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "shell"
  }, (0, _dedent.default)`
          Install-Package Elastic.Clients.Elasticsearch
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "Alternatively, search for Elastic.Clients.Elasticsearch in the NuGet Package Manager UI.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "Connecting to an Elasticsearch Service deployment is achieved by providing the unique Cloud ID for your deployment when configuring the ElasticsearchClient instance. You can retrieve the Cloud ID from the homepage of the deployment in Elasticsearch Service. You also require suitable credentials that your application uses to authenticate with your deployment."), /*#__PURE__*/_react.default.createElement("p", null, "As a security best practice, it is recommended to create a dedicated API key per application, with permissions limited to only those required for any API calls the application is authorized to make."), /*#__PURE__*/_react.default.createElement("p", null, "The following snippet shows you how to create a client instance that connects to an Elasticsearch deployment in the cloud.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "python"
  }, (0, _dedent.default)`
              using Elastic.Clients.Elasticsearch;
              using Elastic.Transport;
              
              var client = new ElasticsearchClient("${cloudId}", new ApiKey("<API_KEY>"));
              
            `)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "The .Net client for Elasticsearch supports connecting to single nodes as well as multiple nodes utilizing a node pool.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsNetSingleNode
  }, "Visit the documentation to learn more about connecting to Elasticsearch.")))));
};
exports.ElasticsearchDotnet = ElasticsearchDotnet;