"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchClientInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _kibana = require("../../../shared/kibana");
var _languages = require("./languages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCloudId = () => {
  const {
    cloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return cloud === null || cloud === void 0 ? void 0 : cloud.cloudId;
};
const ElasticsearchClientInstructions = ({
  language
}) => {
  const cloudId = useCloudId();
  switch (language) {
    case 'dotnet':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchDotnet, null);
    case 'go':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchGo, {
        cloudId: cloudId
      });
    case 'java':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchJava, null);
    case 'javascript':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchJavascript, {
        cloudId: cloudId
      });
    case 'php':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchPhp, {
        cloudId: cloudId
      });
    case 'python':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchPython, {
        cloudId: cloudId
      });
    case 'ruby':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchRuby, {
        cloudId: cloudId
      });
    case 'rust':
      return /*#__PURE__*/_react.default.createElement(_languages.ElasticsearchRust, null);
    default:
      return null;
  }
};
exports.ElasticsearchClientInstructions = ElasticsearchClientInstructions;