"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationContentTabs = exports.SearchApplicationConnectTabs = exports.SEARCH_APPLICATION_CONTENT_PATH = exports.SEARCH_APPLICATION_CONNECT_PATH = exports.ROOT_PATH = exports.EngineViewTabs = exports.ENGINE_TAB_PATH = exports.ENGINE_PATH = exports.ENGINE_CREATION_PATH = exports.ENGINES_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROOT_PATH = '/';
exports.ROOT_PATH = ROOT_PATH;
const ENGINES_PATH = `${ROOT_PATH}search_applications`;
exports.ENGINES_PATH = ENGINES_PATH;
let EngineViewTabs;
exports.EngineViewTabs = EngineViewTabs;
(function (EngineViewTabs) {
  EngineViewTabs["PREVIEW"] = "preview";
  EngineViewTabs["CONTENT"] = "content";
  EngineViewTabs["CONNECT"] = "connect";
})(EngineViewTabs || (exports.EngineViewTabs = EngineViewTabs = {}));
const ENGINE_CREATION_PATH = `${ENGINES_PATH}/new`;
exports.ENGINE_CREATION_PATH = ENGINE_CREATION_PATH;
const ENGINE_PATH = `${ENGINES_PATH}/:engineName`;
exports.ENGINE_PATH = ENGINE_PATH;
const ENGINE_TAB_PATH = `${ENGINE_PATH}/:tabId`;
exports.ENGINE_TAB_PATH = ENGINE_TAB_PATH;
const SEARCH_APPLICATION_CONNECT_PATH = `${ENGINE_PATH}/${EngineViewTabs.CONNECT}/:connectTabId`;
exports.SEARCH_APPLICATION_CONNECT_PATH = SEARCH_APPLICATION_CONNECT_PATH;
let SearchApplicationConnectTabs;
exports.SearchApplicationConnectTabs = SearchApplicationConnectTabs;
(function (SearchApplicationConnectTabs) {
  SearchApplicationConnectTabs["API"] = "api";
  SearchApplicationConnectTabs["DOCUMENTATION"] = "documentation";
})(SearchApplicationConnectTabs || (exports.SearchApplicationConnectTabs = SearchApplicationConnectTabs = {}));
const SEARCH_APPLICATION_CONTENT_PATH = `${ENGINE_PATH}/${EngineViewTabs.CONTENT}/:contentTabId`;
exports.SEARCH_APPLICATION_CONTENT_PATH = SEARCH_APPLICATION_CONTENT_PATH;
let SearchApplicationContentTabs;
exports.SearchApplicationContentTabs = SearchApplicationContentTabs;
(function (SearchApplicationContentTabs) {
  SearchApplicationContentTabs["INDICES"] = "indices";
  SearchApplicationContentTabs["SCHEMA"] = "schema";
})(SearchApplicationContentTabs || (exports.SearchApplicationContentTabs = SearchApplicationContentTabs = {}));