"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesListLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _delete_engines_api_logic = require("../../api/engines/delete_engines_api_logic");
var _fetch_engines_api_logic = require("../../api/engines/fetch_engines_api_logic");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnginesListLogic = (0, _kea.kea)({
  actions: {
    closeDeleteEngineModal: true,
    fetchEngines: true,
    onPaginate: args => ({
      pageNumber: args.page.index
    }),
    openDeleteEngineModal: engine => ({
      engine
    }),
    setIsFirstRequest: true,
    setSearchQuery: searchQuery => ({
      searchQuery
    })
  },
  connect: {
    actions: [_fetch_engines_api_logic.FetchEnginesAPILogic, ['makeRequest', 'apiSuccess', 'apiError'], _delete_engines_api_logic.DeleteEngineAPILogic, ['apiSuccess as deleteSuccess', 'makeRequest as deleteEngine', 'apiError as deleteError']],
    values: [_fetch_engines_api_logic.FetchEnginesAPILogic, ['data', 'status'], _delete_engines_api_logic.DeleteEngineAPILogic, ['status as deleteStatus']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    deleteSuccess: () => {
      actions.closeDeleteEngineModal();
      actions.fetchEngines();
    },
    fetchEngines: async () => {
      actions.makeRequest(values.parameters);
    }
  }),
  path: ['enterprise_search', 'content', 'engine_list_logic'],
  reducers: ({}) => ({
    deleteModalEngine: [null, {
      closeDeleteEngineModal: () => null,
      openDeleteEngineModal: (_, {
        engine
      }) => engine
    }],
    isDeleteModalVisible: [false, {
      closeDeleteEngineModal: () => false,
      openDeleteEngineModal: () => true
    }],
    isFirstRequest: [true, {
      apiError: () => false,
      apiSuccess: () => false,
      setIsFirstRequest: () => true
    }],
    parameters: [{
      count: 0,
      meta: _types.DEFAULT_META
    }, {
      apiSuccess: (state, {
        count
      }) => ({
        ...state,
        count,
        meta: (0, _types.updateMetaTotalState)(state.meta, count) // update total count from response
      }),

      onPaginate: (state, {
        pageNumber
      }) => ({
        ...state,
        meta: (0, _types.updateMetaPageIndex)(state.meta, pageNumber)
      }),
      setSearchQuery: (state, {
        searchQuery
      }) => ({
        ...state,
        searchQuery: searchQuery ? searchQuery : undefined
      })
    }],
    searchQuery: ['', {
      setSearchQuery: (_, {
        searchQuery
      }) => searchQuery
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    deleteModalEngineName: [() => [selectors.deleteModalEngine], engine => {
      var _engine$name;
      return (_engine$name = engine === null || engine === void 0 ? void 0 : engine.name) !== null && _engine$name !== void 0 ? _engine$name : '';
    }],
    hasNoEngines: [() => [selectors.data, selectors.results], (data, results) => {
      var _ref, _data$params, _data$params2;
      return (_ref = (data === null || data === void 0 ? void 0 : (_data$params = data.params) === null || _data$params === void 0 ? void 0 : _data$params.from) === 0 && results.length === 0 && !(data !== null && data !== void 0 && (_data$params2 = data.params) !== null && _data$params2 !== void 0 && _data$params2.q)) !== null && _ref !== void 0 ? _ref : false;
    }],
    isDeleteLoading: [() => [selectors.deleteStatus], status => [_api.Status.LOADING].includes(status)],
    isLoading: [() => [selectors.status, selectors.isFirstRequest], (status, isFirstRequest) => [_api.Status.LOADING, _api.Status.IDLE].includes(status) && isFirstRequest],
    meta: [() => [selectors.parameters], parameters => parameters.meta],
    results: [() => [selectors.data], data => {
      var _data$results;
      return (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [];
    }]
  })
});
exports.EnginesListLogic = EnginesListLogic;