"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesListFlyoutLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _fetch_engine_api_logic = require("../../api/engines/fetch_engine_api_logic");
var _engine_view_logic = require("../engine/engine_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnginesListFlyoutLogic = (0, _kea.kea)({
  connect: {
    actions: [_engine_view_logic.EngineViewLogic, ['fetchEngine as fetchEngine']],
    values: [_engine_view_logic.EngineViewLogic, ['engineData as fetchEngineData', 'fetchEngineApiError as fetchEngineApiError', 'fetchEngineApiStatus as fetchEngineApiStatus']]
  },
  actions: {
    closeFetchIndicesFlyout: true,
    openFetchEngineFlyout: engineName => ({
      engineName
    })
  },
  path: ['enterprise_search', 'content', 'engine_list_flyout_logic'],
  reducers: ({}) => ({
    fetchEngineName: [null, {
      closeFetchIndicesFlyout: () => null,
      openFetchEngineFlyout: (_, {
        engineName
      }) => engineName
    }],
    isFetchEngineFlyoutVisible: [false, {
      closeFetchIndicesFlyout: () => false,
      openFetchEngineFlyout: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isFetchEngineLoading: [() => [selectors.fetchEngineApiStatus], status => [_api.Status.LOADING].includes(status)]
  }),
  listeners: ({}) => ({
    openFetchEngineFlyout: async input => {
      _fetch_engine_api_logic.FetchEngineApiLogic.actions.makeRequest(input);
    }
  })
});
exports.EnginesListFlyoutLogic = EnginesListFlyoutLogic;