"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineListIndicesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _routes = require("../../../enterprise_search_content/routes");
var _health_colors = require("../../../shared/constants/health_colors");
var _encode_path_params = require("../../../shared/encode_path_params");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _engine_error = require("../engine/engine_error");
var _engines_list_flyout_logic = require("./engines_list_flyout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineListIndicesFlyout = () => {
  const {
    fetchEngineData,
    fetchEngineName,
    isFetchEngineLoading,
    isFetchEngineFlyoutVisible,
    fetchEngineApiStatus,
    fetchEngineApiError
  } = (0, _kea.useValues)(_engines_list_flyout_logic.EnginesListFlyoutLogic);
  const {
    closeFetchIndicesFlyout
  } = (0, _kea.useActions)(_engines_list_flyout_logic.EnginesListFlyoutLogic);
  if (!fetchEngineData) return null;
  const {
    indices
  } = fetchEngineData;
  const engineFetchError = fetchEngineApiStatus === _api.Status.ERROR ? true : false;
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.indicesFlyout.table.name.columnTitle', {
      defaultMessage: 'Index name'
    }),
    render: indexName => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "engine-index-link",
      "data-telemetry-id": "entSearchApplications-list-viewIndex",
      to: `${_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL}/${(0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName
      })}`,
      shouldNotCreateHref: true
    }, indexName),
    sortable: true,
    truncateText: true,
    width: '40%'
  }, {
    field: 'health',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.indicesFlyout.table.health.columnTitle', {
      defaultMessage: 'Index health'
    }),
    render: health => {
      var _healthColorsMap$heal;
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: (_healthColorsMap$heal = _health_colors.healthColorsMap[health]) !== null && _healthColorsMap$heal !== void 0 ? _healthColorsMap$heal : ''
      }), "\xA0", health !== null && health !== void 0 ? health : '-');
    },
    sortable: true,
    truncateText: true,
    width: '15%'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.indicesFlyout.table.docsCount.columnTitle', {
      defaultMessage: 'Docs count'
    }),
    sortable: true,
    truncateText: true,
    width: '15%'
  }];
  if (isFetchEngineFlyoutVisible) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      "aria-labelledby": "enginesListFlyout",
      onClose: closeFetchIndicesFlyout
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "engineListFlyout"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.indicesFlyout.title', {
      defaultMessage: 'View Indices'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.enginesList.indicesFlyout.subTitle",
      defaultMessage: "View the indices associated with {engineName}",
      values: {
        engineName: fetchEngineName
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, engineFetchError ? /*#__PURE__*/_react.default.createElement(_engine_error.EngineError, {
      error: fetchEngineApiError
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: indices,
      columns: columns,
      loading: isFetchEngineLoading
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.EngineListIndicesFlyout = EngineListIndicesFlyout;