"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesList = exports.CreateEngineButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _timers = require("../../../shared/constants/timers");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _licensing_callout = require("../../../shared/licensing_callout/licensing_callout");
var _routes = require("../../routes");
var _engines_page_template = require("../layout/engines_page_template");
var _empty_engines_prompt = require("./components/empty_engines_prompt");
var _engines_table = require("./components/tables/engines_table");
var _create_engine_flyout = require("./create_engine_flyout");
var _delete_engine_modal = require("./delete_engine_modal");
var _engines_list_flyout = require("./engines_list_flyout");
var _engines_list_flyout_logic = require("./engines_list_flyout_logic");
var _engines_list_logic = require("./engines_list_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateEngineButton = ({
  disabled
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "create-engine-button-hover-target",
      onMouseEnter: () => setShowPopover(true),
      onMouseLeave: () => setShowPopover(false),
      tabIndex: 0
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "enterprise-search-content-engines-creation-button",
      "data-telemetry-id": "entSearchApplications-list-createEngine",
      isDisabled: disabled,
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_routes.ENGINE_CREATION_PATH)
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.createEngineButtonLabel', {
      defaultMessage: 'Create'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchApplications.createEngineTechnicalPreviewPopover.title",
    defaultMessage: "Technical Preview"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    },
    "data-test-subj": "create-engine-button-popover-content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchApplications.createEngineTechnicalPreviewPopover.body",
    defaultMessage: "This functionality may be changed or removed completely in a future release."
  })))));
};
exports.CreateEngineButton = CreateEngineButton;
const EnginesList = ({
  createEngineFlyoutOpen
}) => {
  var _results$length;
  const {
    closeDeleteEngineModal,
    fetchEngines,
    onPaginate,
    openDeleteEngineModal,
    setSearchQuery,
    setIsFirstRequest
  } = (0, _kea.useActions)(_engines_list_logic.EnginesListLogic);
  const {
    openFetchEngineFlyout
  } = (0, _kea.useActions)(_engines_list_flyout_logic.EnginesListFlyoutLogic);
  const {
    isCloud,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  const {
    deleteModalEngineName,
    hasNoEngines,
    isDeleteModalVisible,
    isLoading,
    meta,
    results,
    searchQuery
  } = (0, _kea.useValues)(_engines_list_logic.EnginesListLogic);
  const throttledSearchQuery = (0, _useThrottle.default)(searchQuery, _timers.INPUT_THROTTLE_DELAY_MS);
  (0, _react.useEffect)(() => {
    // Don't fetch search applications if we don't have a valid license
    if (!isGated) {
      fetchEngines();
    }
  }, [meta.from, meta.size, throttledSearchQuery]);
  (0, _react.useEffect)(() => {
    // We don't want to trigger loading for each search query change, so we need this
    // flag to set if the call to backend is first request.
    if (!isGated) {
      setIsFirstRequest();
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_engine_modal.DeleteEngineModal, {
    engineName: deleteModalEngineName,
    onClose: closeDeleteEngineModal
  }) : null, /*#__PURE__*/_react.default.createElement(_engines_list_flyout.EngineListIndicesFlyout, null), createEngineFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_engine_flyout.CreateEngineFlyout, {
    onClose: () => navigateToUrl(_routes.ENGINES_PATH)
  }), /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
    pageChrome: [],
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.searchApplications.description",
        defaultMessage: "Search Applications help make your Elasticsearch data easily searchable for end users. Create, build, and manage all your search applications here. To learn more, {documentationUrl}.",
        values: {
          documentationUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "engines-documentation-link",
            href: _doc_links.docLinks.searchApplications,
            target: "_blank",
            "data-telemetry-id": "entSearchApplications-documentation-viewDocumentaion"
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.documentation', {
            defaultMessage: 'explore our Search Applications documentation'
          }))
        }
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.title', {
        defaultMessage: 'Search Applications'
      }),
      rightSideItems: isLoading ? [] : !hasNoEngines ? [/*#__PURE__*/_react.default.createElement(CreateEngineButton, {
        disabled: isGated
      })] : []
    },
    pageViewTelemetry: "Search Applications",
    isLoading: isLoading && !isGated
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.SEARCH_APPLICATIONS
  })), !hasNoEngines && !isGated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchQuery,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.searchPlaceholder', {
      defaultMessage: 'Search Applications'
    }),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.searchBar.ariaLabel', {
      defaultMessage: 'Search Applications'
    }),
    fullWidth: true,
    onChange: event => {
      setSearchQuery(event.currentTarget.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.searchPlaceholder.description', {
    defaultMessage: 'Locate a search application via name or by its included indices.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchApplications.enginesList.description",
    defaultMessage: "Showing {from}-{to} of {total}",
    values: {
      from: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + 1
      })),
      to: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + ((_results$length = results === null || results === void 0 ? void 0 : results.length) !== null && _results$length !== void 0 ? _results$length : 0)
      })),
      total: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.total
      })
    }
  })), /*#__PURE__*/_react.default.createElement(_engines_table.EnginesListTable, {
    enginesList: results,
    meta: meta,
    onChange: onPaginate,
    onDelete: openDeleteEngineModal,
    viewEngineIndices: openFetchEngineFlyout,
    loading: false
  })) : /*#__PURE__*/_react.default.createElement(_empty_engines_prompt.EmptyEnginesPrompt, null, /*#__PURE__*/_react.default.createElement(CreateEngineButton, {
    disabled: isGated
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("div", null)));
};
exports.EnginesList = EnginesList;