"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteEngineModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _telemetry_logic = require("../../../shared/telemetry/telemetry_logic");
var _engines_list_logic = require("./engines_list_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteEngineModal = ({
  engineName,
  onClose
}) => {
  const {
    deleteEngine
  } = (0, _kea.useActions)(_engines_list_logic.EnginesListLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  const {
    isDeleteLoading
  } = (0, _kea.useValues)(_engines_list_logic.EnginesListLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engineList.deleteEngineModal.title', {
      defaultMessage: 'Permanently delete this search application?'
    }),
    onCancel: onClose,
    onConfirm: () => {
      deleteEngine({
        engineName
      });
      sendEnterpriseSearchTelemetry({
        action: 'clicked',
        metric: 'entSearchApplications-engineView-deleteEngineConfirm'
      });
    },
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.engineList.deleteEngineModal.confirmButton.title', {
      defaultMessage: 'Yes, delete this search application'
    }),
    buttonColor: "danger",
    isLoading: isDeleteLoading
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engineList.deleteEngineModal.delete.description', {
    defaultMessage: 'Deleting your search application is not a reversible action. Your indices will not be affected. '
  })));
};
exports.DeleteEngineModal = DeleteEngineModal;