"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEngineLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _create_engine_api_logic = require("../../api/engines/create_engine_api_logic");
var _routes = require("../../routes");
var _engines_list_logic = require("./engines_list_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateEngineLogic = (0, _kea.kea)({
  actions: {
    createEngine: true,
    setEngineName: engineName => ({
      engineName
    }),
    setSelectedIndices: indices => ({
      indices
    })
  },
  connect: {
    actions: [_engines_list_logic.EnginesListLogic, ['fetchEngines'], _create_engine_api_logic.CreateEngineApiLogic, ['makeRequest as createEngineRequest', 'apiSuccess as engineCreated', 'apiError as engineCreateError']],
    values: [_create_engine_api_logic.CreateEngineApiLogic, ['status as createEngineStatus', 'error as createEngineError']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    createEngine: () => {
      actions.createEngineRequest({
        engineName: values.engineName,
        indices: values.selectedIndices
      });
    },
    engineCreated: () => {
      actions.fetchEngines();
      _kibana.KibanaLogic.values.navigateToUrl(_routes.ENGINES_PATH);
    }
  }),
  path: ['enterprise_search', 'content', 'create_engine_logic'],
  reducers: {
    engineName: ['', {
      setEngineName: (_, {
        engineName
      }) => engineName
    }],
    selectedIndices: [[], {
      setSelectedIndices: (_, {
        indices
      }) => indices
    }]
  },
  selectors: ({
    selectors
  }) => ({
    createDisabled: [() => [selectors.indicesStatus, selectors.engineNameStatus], (indicesStatus, engineNameStatus) => indicesStatus !== 'complete' || engineNameStatus !== 'complete'],
    engineNameStatus: [() => [selectors.engineName], engineName => {
      if (engineName.length === 0) return 'incomplete';
      return 'complete';
    }],
    formDisabled: [() => [selectors.createEngineStatus], createEngineStatus => createEngineStatus === _api.Status.LOADING],
    indicesStatus: [() => [selectors.selectedIndices], selectedIndices => selectedIndices.length > 0 ? 'complete' : 'incomplete']
  })
});
exports.CreateEngineLogic = CreateEngineLogic;