"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEngineFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../common/types/api");
var _constants = require("../../../shared/constants");
var _doc_links = require("../../../shared/doc_links");
var _handle_api_errors = require("../../../shared/flash_messages/handle_api_errors");
var _query_params = require("../../../shared/query_params");
var _indices_select_combobox = require("./components/indices_select_combobox");
var _create_engine_logic = require("./create_engine_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateEngineFlyout = ({
  onClose
}) => {
  const {
    createEngine,
    setEngineName,
    setSelectedIndices
  } = (0, _kea.useActions)(_create_engine_logic.CreateEngineLogic);
  const {
    createDisabled,
    createEngineError,
    createEngineStatus,
    engineName,
    engineNameStatus,
    formDisabled,
    indicesStatus,
    selectedIndices
  } = (0, _kea.useValues)(_create_engine_logic.CreateEngineLogic);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    ...params
  } = (0, _query_params.parseQueryParams)(search);
  const indexName = params[_constants.ESINDEX_QUERY_PARAMETER];
  const onIndicesChange = selectedOptions => {
    setSelectedIndices(selectedOptions.map(option => option.label));
  };
  (0, _react.useEffect)(() => {
    if (indexName && typeof indexName === 'string') setSelectedIndices([indexName]);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.headerTitle', {
    defaultMessage: 'Create a Search Application'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engines.createEngine.headerSubTitle",
    defaultMessage: "Explore our {enginesDocsLink} to learn more!",
    values: {
      enginesDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.searchApplications,
        target: "_blank",
        "data-telemetry-id": "entSearchApplications-createEngine-docsLink",
        external: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.header.docsLink', {
        defaultMessage: 'Search Applications documentation'
      }))
    }
  }))), createEngineStatus === _api.Status.ERROR && createEngineError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.header.createError.title', {
      defaultMessage: 'Error creating search application'
    })
  }, (0, _handle_api_errors.getErrorsFromHttpResponse)(createEngineError).map((errMessage, i) => /*#__PURE__*/_react.default.createElement("p", {
    id: `createErrorMsg.${i}`
  }, errMessage))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Technical Preview feature",
    color: "warning",
    iconType: "beaker"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engines.createEngine.technicalPreviewCallOut.title",
    defaultMessage: "This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will take a best effort approach to fix any issues, but features in technical preview are not subject to the support SLA of official GA features."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_indices_select_combobox.IndicesSelectComboBox, {
        fullWidth: true,
        isDisabled: formDisabled,
        onChange: onIndicesChange,
        selectedOptions: selectedIndices.map(index => (0, _indices_select_combobox.indexToOption)(index))
      }),
      status: indicesStatus,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.selectIndices.title', {
        defaultMessage: 'Select indices'
      })
    }, {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        fullWidth: true,
        disabled: formDisabled,
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.nameEngine.placeholder', {
          defaultMessage: 'Search application name'
        }),
        value: engineName,
        onChange: e => setEngineName(e.target.value)
      }),
      status: engineNameStatus,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.nameEngine.title', {
        defaultMessage: 'Name your search application'
      })
    }]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: formDisabled,
    "data-telemetry-id": "entSearchApplications-createEngine-cancel",
    onClick: onClose
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: createDisabled || formDisabled,
    "data-telemetry-id": "entSearchApplications-createEngine-submit",
    fill: true,
    iconType: "plusInCircle",
    onClick: () => {
      createEngine();
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engines.createEngine.submit', {
    defaultMessage: 'Create'
  }))))));
};
exports.CreateEngineFlyout = CreateEngineFlyout;