"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesListTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _formatted_date_time = require("../../../../../shared/formatted_date_time");
var _kibana = require("../../../../../shared/kibana");
var _page_to_pagination = require("../../../../../shared/pagination/page_to_pagination");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _telemetry_logic = require("../../../../../shared/telemetry/telemetry_logic");
var _routes = require("../../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnginesListTable = ({
  enginesList,
  isLoading,
  meta,
  onChange,
  onDelete,
  viewEngineIndices
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.name', {
      defaultMessage: 'Search Application Name'
    }),
    mobileOptions: {
      header: true,
      enlarge: true,
      width: '100%'
    },
    render: name => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "engine-link",
      "data-telemetry-id": "entSearchApplications-table-viewEngine",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
        engineName: name
      })
    }, name),
    truncateText: true,
    width: '30%'
  }, {
    field: 'updated_at_millis',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.lastUpdated', {
      defaultMessage: 'Last updated'
    }),
    dataType: 'number',
    render: dateString => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(dateString),
      hideTime: true
    })
  }, {
    field: 'indices',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.indices', {
      defaultMessage: 'Indices'
    }),
    align: 'right',
    render: (indices, engine) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      className: "engineListTableFlyoutButton",
      "data-test-subj": "engineListTableIndicesFlyoutButton",
      "data-telemetry-id": "entSearchApplications-table-viewEngineIndices",
      onClick: () => viewEngineIndices(engine.name)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.enginesList.table.column.view.indices",
      defaultMessage: "{indicesCount, number} {indicesCount, plural, one {index} other {indices}}",
      values: {
        indicesCount: indices.length
      }
    }))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _constants.MANAGE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.actions.view.buttonDescription', {
        defaultMessage: 'View this search application'
      }),
      type: 'icon',
      icon: 'eye',
      onClick: engine => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
        engineName: engine.name
      }))
    }, {
      color: 'danger',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.enginesList.table.column.action.delete.buttonDescription', {
        defaultMessage: 'Delete this search application'
      }),
      type: 'icon',
      icon: 'trash',
      isPrimary: false,
      name: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.engineList.table.column.actions.deleteEngineLabel', {
        defaultMessage: 'Delete this search application'
      }),
      onClick: engine => {
        onDelete(engine);
        sendEnterpriseSearchTelemetry({
          action: 'clicked',
          metric: 'entSearchApplications-table-deleteEngine'
        });
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: enginesList,
    columns: columns,
    pagination: {
      ...(0, _page_to_pagination.pageToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: onChange,
    loading: isLoading
  });
};
exports.EnginesListTable = EnginesListTable;