"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _engines_page_template = require("../layout/engines_page_template");
var _add_indices_flyout = require("./add_indices_flyout");
var _engine_error = require("./engine_error");
var _engine_indices = require("./engine_indices");
var _engine_indices_logic = require("./engine_indices_logic");
var _engine_schema = require("./engine_schema");
var _engine_view_logic = require("./engine_view_logic");
require("./search_application_layout.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageTitle = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.content.pageTitle', {
  defaultMessage: 'Content'
});
const INDICES_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.content.indicesTabTitle', {
  defaultMessage: 'Indices'
});
const SCHEMA_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchApplications.content.schemaTabTitle', {
  defaultMessage: 'Schema'
});
const getTabBreadCrumb = tabId => {
  switch (tabId) {
    case _routes.SearchApplicationContentTabs.INDICES:
      return INDICES_TAB_TITLE;
    case _routes.SearchApplicationContentTabs.SCHEMA:
      return SCHEMA_TAB_TITLE;
    default:
      return tabId;
  }
};
const ContentTabs = Object.values(_routes.SearchApplicationContentTabs);
const SearchApplicationContent = () => {
  const {
    engineName,
    isLoadingEngine
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    addIndicesFlyoutOpen
  } = (0, _kea.useValues)(_engine_indices_logic.EngineIndicesLogic);
  const {
    closeAddIndicesFlyout,
    openAddIndicesFlyout
  } = (0, _kea.useActions)(_engine_indices_logic.EngineIndicesLogic);
  const {
    contentTabId = _routes.SearchApplicationContentTabs.INDICES
  } = (0, _reactRouterDom.useParams)();
  if (!ContentTabs.includes(contentTabId)) {
    return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
      pageChrome: [engineName, pageTitle],
      pageViewTelemetry: _routes.EngineViewTabs.CONTENT,
      isLoading: isLoadingEngine,
      pageHeader: {
        bottomBorder: false,
        className: 'searchApplicationHeaderBackgroundColor',
        pageTitle,
        rightSideItems: []
      },
      engineName: engineName
    }, /*#__PURE__*/_react.default.createElement(_engine_error.EngineError, {
      notFound: true
    }));
  }
  const onTabClick = tab => () => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: tab,
      engineName
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
    pageChrome: [engineName, pageTitle, getTabBreadCrumb(contentTabId)],
    pageViewTelemetry: _routes.EngineViewTabs.CONTENT,
    isLoading: isLoadingEngine,
    pageHeader: {
      bottomBorder: false,
      breadcrumbs: [{
        color: 'primary',
        onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
          engineName
        })),
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft"
        }), " ", engineName)
      }],
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchApplications-indices-addNewIndices",
        "data-test-subj": "engine-add-new-indices-btn",
        iconType: "plusInCircle",
        fill: true,
        onClick: openAddIndicesFlyout
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.indices.addNewIndicesButton', {
        defaultMessage: 'Add new indices'
      }))],
      tabs: [{
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.INDICES,
        label: INDICES_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationContentTabs.INDICES)
      }, {
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.SCHEMA,
        label: SCHEMA_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationContentTabs.SCHEMA)
      }]
    },
    engineName: engineName
  }, contentTabId === _routes.SearchApplicationContentTabs.INDICES && /*#__PURE__*/_react.default.createElement(_engine_indices.EngineIndices, null), contentTabId === _routes.SearchApplicationContentTabs.SCHEMA && /*#__PURE__*/_react.default.createElement(_engine_schema.EngineSchema, null), addIndicesFlyoutOpen && /*#__PURE__*/_react.default.createElement(_add_indices_flyout.AddIndicesFlyout, {
    onClose: closeAddIndicesFlyout
  }));
};
exports.SearchApplicationContent = SearchApplicationContent;