"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineViewLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _fetch_engine_api_logic = require("../../api/engines/fetch_engine_api_logic");
var _fetch_engine_field_capabilities_api_logic = require("../../api/engines/fetch_engine_field_capabilities_api_logic");
var _routes = require("../../routes");
var _engines_list_logic = require("../engines/engines_list_logic");
var _engine_name_logic = require("./engine_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineViewLogic = (0, _kea.kea)({
  actions: {
    closeDeleteEngineModal: true,
    openDeleteEngineModal: true
  },
  connect: {
    actions: [_fetch_engine_api_logic.FetchEngineApiLogic, ['makeRequest as fetchEngine'], _fetch_engine_field_capabilities_api_logic.FetchEngineFieldCapabilitiesApiLogic, ['makeRequest as fetchEngineSchema'], _engines_list_logic.EnginesListLogic, ['deleteSuccess']],
    values: [_engine_name_logic.EngineNameLogic, ['engineName'], _fetch_engine_api_logic.FetchEngineApiLogic, ['data as engineData', 'status as fetchEngineApiStatus', 'error as fetchEngineApiError'], _fetch_engine_field_capabilities_api_logic.FetchEngineFieldCapabilitiesApiLogic, ['data as engineSchemaData', 'status as fetchEngineSchemaApiStatus', 'error as fetchEngineSchemaApiError']]
  },
  listeners: ({
    actions
  }) => ({
    deleteSuccess: () => {
      actions.closeDeleteEngineModal();
      _kibana.KibanaLogic.values.navigateToUrl(_routes.ENGINES_PATH);
    }
  }),
  path: ['enterprise_search', 'content', 'engine_view_logic'],
  reducers: () => ({
    isDeleteModalVisible: [false, {
      closeDeleteEngineModal: () => false,
      openDeleteEngineModal: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isLoadingEngine: [() => [selectors.fetchEngineApiStatus, selectors.engineData], (status, data) => {
      return status === _api.Status.IDLE || !data && status === _api.Status.LOADING;
    }],
    isLoadingEngineSchema: [() => [selectors.fetchEngineSchemaApiStatus], status => [_api.Status.LOADING, _api.Status.IDLE].includes(status)],
    schemaFields: [() => [selectors.engineSchemaData], data => (data === null || data === void 0 ? void 0 : data.fields) || []]
  })
});
exports.EngineViewLogic = EngineViewLogic;