"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _delete_engine_modal = require("../engines/delete_engine_modal");
var _engines_page_template = require("../layout/engines_page_template");
var _engine_connect = require("./engine_connect/engine_connect");
var _engine_error = require("./engine_error");
var _engine_search_preview = require("./engine_search_preview/engine_search_preview");
var _engine_view_logic = require("./engine_view_logic");
var _header_docs_action = require("./header_docs_action");
var _search_application_content = require("./search_application_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineView = () => {
  const {
    fetchEngine,
    closeDeleteEngineModal
  } = (0, _kea.useActions)(_engine_view_logic.EngineViewLogic);
  const {
    engineName,
    fetchEngineApiError,
    fetchEngineApiStatus,
    isDeleteModalVisible
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    tabId = _routes.EngineViewTabs.PREVIEW
  } = (0, _reactRouterDom.useParams)();
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useLayoutEffect)(() => {
    renderHeaderActions(_header_docs_action.EngineHeaderDocsAction);
    return () => {
      renderHeaderActions();
    };
  }, []);
  (0, _react.useEffect)(() => {
    fetchEngine({
      engineName
    });
  }, [engineName]);
  if (fetchEngineApiStatus === _api.Status.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
      isEmptyState: true,
      pageChrome: [engineName],
      pageViewTelemetry: tabId,
      pageHeader: {
        bottomBorder: false,
        pageTitle: engineName,
        rightSideItems: []
      },
      engineName: engineName,
      emptyState: /*#__PURE__*/_react.default.createElement(_engine_error.EngineError, {
        error: fetchEngineApiError
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_engine_modal.DeleteEngineModal, {
    engineName: engineName,
    onClose: closeDeleteEngineModal
  }) : null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_routes.ENGINE_PATH}/${_routes.EngineViewTabs.PREVIEW}`,
    component: _engine_search_preview.EngineSearchPreview
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONTENT_PATH,
    component: _search_application_content.SearchApplicationContent
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.ENGINE_PATH}/${_routes.EngineViewTabs.CONTENT}`,
    to: `${_routes.ENGINE_PATH}/${_routes.EngineViewTabs.CONTENT}/${_routes.SearchApplicationContentTabs.INDICES}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONNECT_PATH,
    component: _engine_connect.EngineConnect
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.ENGINE_PATH}/${_routes.EngineViewTabs.CONNECT}`,
    to: `${_routes.ENGINE_PATH}/${_routes.EngineViewTabs.CONNECT}/${_routes.SearchApplicationConnectTabs.API}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
    isEmptyState: true,
    pageChrome: [engineName],
    pageViewTelemetry: tabId,
    pageHeader: {
      bottomBorder: false,
      pageTitle: engineName,
      rightSideItems: []
    },
    engineName: engineName
  }, /*#__PURE__*/_react.default.createElement(_engine_error.EngineError, {
    notFound: true
  })))));
};
exports.EngineView = EngineView;