"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineSearchPreviewLogic = void 0;
var _kea = require("kea");
var _fetch_engine_field_capabilities_api_logic = require("../../../api/engines/fetch_engine_field_capabilities_api_logic");
var _engine_name_logic = require("../engine_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineSearchPreviewLogic = (0, _kea.kea)({
  connect: {
    actions: [_fetch_engine_field_capabilities_api_logic.FetchEngineFieldCapabilitiesApiLogic, ['makeRequest as fetchEngineFieldCapabilities']],
    values: [_engine_name_logic.EngineNameLogic, ['engineName'], _fetch_engine_field_capabilities_api_logic.FetchEngineFieldCapabilitiesApiLogic, ['data as engineFieldCapabilitiesData']]
  },
  events: ({
    actions,
    values
  }) => ({
    afterMount: () => {
      if (!values.engineFieldCapabilitiesData) {
        actions.fetchEngineFieldCapabilities({
          engineName: values.engineName
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'engine_search_preview_logic'],
  selectors: ({
    selectors
  }) => ({
    fieldTypesByIndex: [() => [selectors.engineFieldCapabilitiesData], data => {
      if (!data) return {};
      return data.fields.reduce((out, field) => field.indices.reduce((acc, index) => ({
        ...acc,
        [index.name]: {
          ...(acc[index.name] || {}),
          [field.name]: index.type
        }
      }), out), {});
    }],
    resultFields: [() => [selectors.engineFieldCapabilitiesData], data => {
      if (!data) return {};
      return Object.fromEntries(data.fields.filter(({
        metadata_field: isMeta
      }) => !isMeta).map(({
        name
      }) => [name, {
        raw: {},
        snippet: {
          fallback: true
        }
      }]));
    }],
    sortableFields: [() => [selectors.engineFieldCapabilitiesData], data => {
      if (!data) return [];
      return data.fields.filter(({
        metadata_field: isMeta,
        aggregatable
      }) => aggregatable && !isMeta).map(({
        name
      }) => name).sort();
    }]
  })
});
exports.EngineSearchPreviewLogic = EngineSearchPreviewLogic;