"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineSearchPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _searchUiEnginesConnector = _interopRequireDefault(require("@elastic/search-ui-engines-connector"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../shared/doc_links");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _telemetry = require("../../../../shared/telemetry");
var _routes = require("../../../routes");
var _engines_page_template = require("../../layout/engines_page_template");
var _engine_indices_logic = require("../engine_indices_logic");
var _engine_view_logic = require("../engine_view_logic");
var _document_context = require("./document_context");
var _document_flyout = require("./document_flyout");
var _engine_search_preview_logic = require("./engine_search_preview_logic");
var _search_ui_components = require("./search_ui_components");
require("../search_application_layout.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InternalEngineTransporter {
  constructor(http, engineName // uncomment and add setLastAPICall to constructor when view this API call is needed // private setLastAPICall?: (apiCallData: APICallData) => void
  ) {
    this.http = http;
    this.engineName = engineName;
  }
  async performRequest(request) {
    const url = `/internal/enterprise_search/engines/${this.engineName}/search`;
    const response = await this.http.post(url, {
      body: JSON.stringify(request)
    });

    // this.setLastAPICall({ request, response }); Uncomment when view this API call is needed

    const withUniqueIds = {
      ...response,
      hits: {
        ...response.hits,
        hits: response.hits.hits.map(hit => ({
          ...hit,
          // The `__id` field is the actual document ID.
          __id: hit._id,
          // Search UI expects a unique `_id` for use as a React key but
          // because Search Applications can have multiple indices, keys
          // can be duplicated. Here we prefix the `_id` with the index
          // name to ensure uniqueness.
          _id: `${hit._index}__${hit._id}`
        }))
      }
    };
    return withUniqueIds;
  }
}
const ConfigurationPopover = ({
  engineName,
  showConfiguration,
  setCloseConfiguration
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    engineData
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    openDeleteEngineModal
  } = (0, _kea.useActions)(_engine_view_logic.EngineViewLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    isOpen: showConfiguration,
    panelPaddingSize: "none",
    closePopover: setCloseConfiguration,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: setCloseConfiguration
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.buttonTitle', {
      defaultMessage: 'Configuration'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.contentTitle', {
    defaultMessage: 'Content'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Indices",
    icon: "tableDensityExpanded",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.INDICES,
      engineName
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.content.Indices', {
    defaultMessage: 'Indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Schema",
    icon: "kqlField",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.SCHEMA,
      engineName
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.content.Schema', {
    defaultMessage: 'Schema'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.connectTitle', {
    defaultMessage: 'Connect'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Api",
    icon: "lock",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONNECT_PATH, {
      connectTabId: _routes.SearchApplicationConnectTabs.API,
      engineName
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.connect.Api', {
    defaultMessage: 'API'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.settingsTitle', {
    defaultMessage: 'Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "delete",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      color: "danger"
    }),
    onClick: () => {
      if (engineData) {
        openDeleteEngineModal();
        sendEnterpriseSearchTelemetry({
          action: 'clicked',
          metric: 'entSearchApplications-engineView-deleteEngine'
        });
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.configuration.settings.delete', {
    defaultMessage: 'Delete this app'
  })))))));
};
const EngineSearchPreview = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  // const [showAPICallFlyout, setShowAPICallFlyout] = useState<boolean>(false);    Uncomment when view this API call is needed
  const [showConfigurationPopover, setShowConfigurationPopover] = (0, _react.useState)(false);
  // const [lastAPICall, setLastAPICall] = useState<null | APICallData>(null); Uncomment when view this API call is needed
  const {
    engineName,
    isLoadingEngine
  } = (0, _kea.useValues)(_engine_view_logic.EngineViewLogic);
  const {
    resultFields,
    sortableFields
  } = (0, _kea.useValues)(_engine_search_preview_logic.EngineSearchPreviewLogic);
  const {
    engineData
  } = (0, _kea.useValues)(_engine_indices_logic.EngineIndicesLogic);
  const config = (0, _react.useMemo)(() => {
    const transporter = new InternalEngineTransporter(http, engineName);
    const connector = new _searchUiEnginesConnector.default(transporter);
    return {
      alwaysSearchOnInitialLoad: true,
      apiConnector: connector,
      hasA11yNotifications: true,
      searchQuery: {
        result_fields: resultFields
      }
    };
  }, [http, engineName, resultFields]);
  if (!engineData) return null;
  return /*#__PURE__*/_react.default.createElement(_engines_page_template.EnterpriseSearchEnginesPageTemplate, {
    pageChrome: [engineName, _i18n.i18n.translate('xpack.enterpriseSearch.content.engine.searchPreview.pageChrome', {
      defaultMessage: 'Search Preview'
    })],
    pageViewTelemetry: _routes.EngineViewTabs.PREVIEW,
    isLoading: isLoadingEngine,
    pageHeader: {
      bottomBorder: false,
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.engine.searchPreview.pageTitle",
        defaultMessage: "{engineName}",
        values: {
          engineName
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ConfigurationPopover, {
        engineName: engineName,
        showConfiguration: showConfigurationPopover,
        setCloseConfiguration: () => setShowConfigurationPopover(!showConfigurationPopover)
      }))]
    },
    engineName: engineName
  }, /*#__PURE__*/_react.default.createElement(_document_context.DocumentProvider, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchProvider, {
    config: config
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchBox, {
    inputView: _search_ui_components.InputView
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '240px'
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.ResultsPerPage, {
    view: _search_ui_components.ResultsPerPageView,
    options: _search_ui_components.RESULTS_PER_PAGE_OPTIONS
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_search_ui_components.Sorting, {
    sortableFields: sortableFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.searchTemplates,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.engine.searchPreview.improveResultsLink",
    defaultMessage: "Improve these results"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.PagingInfo, {
    view: _search_ui_components.PagingInfoView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reactSearchUi.Results, {
    view: _search_ui_components.ResultsView,
    resultView: _search_ui_components.ResultView
  })))), /*#__PURE__*/_react.default.createElement(_document_flyout.DocumentFlyout, null)));
};
exports.EngineSearchPreview = EngineSearchPreview;